/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.base;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmAnimation;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmPoseAnimation;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class BaseHierarchicalArmHeadModel<E extends Mob>
extends HierarchicalModel<E>
implements ArmedModel,
HeadedModel,
EasyNPCModel<E>,
HumanoidArmAnimation,
HumanoidArmPoseAnimation {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, Boolean> modelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);
    protected final ModelPart root;
    protected final ModelPart body;
    protected final ModelPart head;
    protected final ModelPart rightArm;
    protected final ModelPart leftArm;
    protected final ModelPart rightLeg;
    protected final ModelPart leftLeg;

    public BaseHierarchicalArmHeadModel(ModelPart modelPart) {
        ModelPart bodyModelPart;
        ModelPart rootModelPart;
        try {
            rootModelPart = this.defineModelPart(ModelPartType.ROOT, modelPart, "root");
        }
        catch (NoSuchElementException e) {
            rootModelPart = this.defineModelPart(ModelPartType.ROOT, modelPart);
        }
        try {
            bodyModelPart = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        }
        catch (NoSuchElementException e) {
            bodyModelPart = null;
        }
        this.root = rootModelPart;
        this.head = this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.body = bodyModelPart;
        this.rightArm = this.defineModelPart(ModelPartType.RIGHT_ARM, modelPart, "right_arm");
        this.leftArm = this.defineModelPart(ModelPartType.LEFT_ARM, modelPart, "left_arm");
        this.rightLeg = this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg");
        this.leftLeg = this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        if (this.body != null) {
            this.resetModelPart(ModelPartType.BODY, this.body);
        }
        this.resetModelPart(ModelPartType.RIGHT_ARM, this.rightArm);
        this.resetModelPart(ModelPartType.LEFT_ARM, this.leftArm);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.rightLeg);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.leftLeg);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public boolean animateModelArms(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidArmAnimation.animateHumanoidModelArms(rightArmPart, leftArmPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean animateModelArmPose(E entity, ModelArmPose modelArmPose, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return HumanoidArmPoseAnimation.animateHumanoidArmPose(entity, modelArmPose, this.head, this.body, this.rightArm, this.leftArm, this.f_102608_, ageInTicks);
    }

    @Override
    public void setupCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftArm, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightArm, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean setupCrouchingModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.f_104203_ = 0.5f;
        this.body.f_104201_ = 3.2f;
        this.head.f_104201_ = 4.2f;
        this.leftArm.f_104203_ += 0.4f;
        this.leftArm.f_104201_ = 5.2f;
        this.leftLeg.f_104201_ = 12.2f;
        this.leftLeg.f_104202_ = 4.0f;
        this.rightArm.f_104203_ += 0.4f;
        this.rightArm.f_104201_ = 5.2f;
        this.rightLeg.f_104201_ = 12.2f;
        this.rightLeg.f_104202_ = 4.0f;
        return true;
    }

    protected ModelPart getArm(HumanoidArm humanoidArm) {
        return humanoidArm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        this.getArm(humanoidArm).m_104299_(poseStack);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, Boolean> getModelPartVisibilityMap() {
        return this.modelPartVisibilityMap;
    }

    @Override
    public Map<ModelPartType, ModelPart> getModelPartMap() {
        return this.modelPartMap;
    }
}

