/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.raw.SkeletonRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.AbstractSkeleton;

public class SkeletonRawRenderer
extends SkeletonRenderer {
    protected static final Map<SkeletonRaw.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(SkeletonRaw.Variant.class), map -> {
        map.put(SkeletonRaw.Variant.SKELETON, new ResourceLocation("textures/entity/skeleton/skeleton.png"));
        map.put(SkeletonRaw.Variant.STRAY, new ResourceLocation("textures/entity/skeleton/stray.png"));
        map.put(SkeletonRaw.Variant.WITHER_SKELETON, new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)SkeletonRaw.Variant.SKELETON);

    public SkeletonRawRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation m_5478_(AbstractSkeleton skeleton) {
        if (skeleton instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)skeleton;
            return this.getEntityTexture(easyNPC);
        }
        return super.m_5478_(skeleton);
    }

    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    public ResourceLocation getCustomTexture(SkinData<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public ResourceLocation getRemoteTexture(SkinData<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    public ResourceLocation getTextureByVariant(Enum<?> variant) {
        return TEXTURE_BY_VARIANT != null ? TEXTURE_BY_VARIANT.getOrDefault(variant, DEFAULT_TEXTURE) : Constants.BLANK_ENTITY_TEXTURE;
    }

    public <N extends EasyNPC<?>> ResourceLocation getEntityTexture(N easyNPC) {
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        };
    }
}

