/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.attribute;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.attribute.AttributeConfigurationScreen;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.ValueUtils;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class DisplayAttributeConfigurationScreen<T extends ConfigurationMenu>
extends AttributeConfigurationScreen<T> {
    private static final HashSet<DisplayAttributeType> VISIBILITY_ATTRIBUTES = new HashSet<DisplayAttributeType>(Arrays.asList(DisplayAttributeType.VISIBLE_AT_DAY, DisplayAttributeType.VISIBLE_AT_NIGHT, DisplayAttributeType.VISIBLE_IN_CREATIVE, DisplayAttributeType.VISIBLE_IN_SPECTATOR, DisplayAttributeType.VISIBLE_IN_STANDARD, DisplayAttributeType.VISIBLE_TO_OWNER, DisplayAttributeType.VISIBLE_TO_TEAM));
    private final HashSet<Checkbox> visibilityCheckboxSet = new HashSet();
    private EditBox lightLevelBox;
    private Button lightLevelSaveButton;

    public DisplayAttributeConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.displayAttributeButton.f_93623_ = false;
        int firstButtonRow = this.leftPos + 10;
        DisplayAttributeData<?> displayAttributeData = this.getEasyNPC().getEasyNPCDisplayAttributeData();
        this.lightLevelBox = (EditBox)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, firstButtonRow + 100, this.buttonTopPos + 25, 20, displayAttributeData.getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL), 2));
        this.lightLevelBox.m_94151_(value -> {
            if (this.lightLevelSaveButton != null) {
                this.lightLevelSaveButton.f_93623_ = ValueUtils.isNumericValue(value, 0, 15) && ValueUtils.getIntValue(value).intValue() != this.getEasyNPC().getEasyNPCDisplayAttributeData().getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
            }
        });
        this.lightLevelSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.lightLevelBox.m_252754_() + this.lightLevelBox.m_5711_() + 2, this.lightLevelBox.m_252907_() - 1, onPress -> {
            int lightLevel = Integer.parseInt(this.lightLevelBox.m_94155_());
            if (lightLevel >= 0 && lightLevel <= 15) {
                NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), DisplayAttributeType.LIGHT_LEVEL, lightLevel);
            }
        }));
        this.lightLevelSaveButton.f_93623_ = false;
        Checkbox isVisibleCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(firstButtonRow, this.buttonTopPos + 45, DisplayAttributeType.VISIBLE.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE), checkbox -> {
            this.visibilityCheckboxSet.forEach(visibilityCheckbox -> {
                visibilityCheckbox.f_93623_ = checkbox.selected();
            });
            NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), DisplayAttributeType.VISIBLE, checkbox.selected());
        }));
        int checkboxTopPos = this.buttonTopPos + 65;
        for (DisplayAttributeType displayAttributeType : VISIBILITY_ATTRIBUTES) {
            Checkbox visibilityCheckbox = new Checkbox(firstButtonRow, checkboxTopPos, displayAttributeType.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(displayAttributeType), checkbox -> NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), displayAttributeType, checkbox.selected()));
            visibilityCheckbox.f_93623_ = isVisibleCheckbox.selected();
            this.visibilityCheckboxSet.add((Checkbox)this.m_142416_((GuiEventListener)visibilityCheckbox));
            checkboxTopPos += 20;
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        if (this.lightLevelBox != null) {
            Text.drawConfigString(guiGraphics, this.f_96547_, "light_level", this.lightLevelBox.m_252754_() - 100, this.lightLevelBox.m_252907_() + 4);
        }
        if (this.getEasyNPC() != null) {
            ScreenHelper.renderScaledEntityAvatar(this.leftPos + 260, this.contentTopPos + 180, 30, (float)(this.leftPos + 50) - this.xMouse, (float)(this.contentTopPos + 70) - this.yMouse, this.getEasyNPC());
        }
    }
}

