/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.model;

public enum ModelPart {
    ARMS("Arms"),
    BODY("Body"),
    HEAD("Head"),
    LEFT_ARM("LeftArm"),
    LEFT_LEG("LeftLeg"),
    RIGHT_ARM("RightArm"),
    RIGHT_LEG("RightLeg"),
    ROOT("Root"),
    BOOTS("Boots"),
    CHESTPLATE("Chestplate"),
    HELMET("Helmet"),
    LEGGINGS("Leggings"),
    UNKNOWN("Unknown");

    public final String tagName;

    private ModelPart(String tagName) {
        this.tagName = tagName;
    }

    public static ModelPart get(String modelPart) {
        if (modelPart == null || modelPart.isEmpty()) {
            return UNKNOWN;
        }
        try {
            return ModelPart.valueOf(modelPart);
        }
        catch (IllegalArgumentException e) {
            for (ModelPart modelPartEnum : ModelPart.values()) {
                if (!modelPartEnum.tagName.equalsIgnoreCase(modelPart)) continue;
                return modelPartEnum;
            }
            return UNKNOWN;
        }
    }

    public String getTagName() {
        return this.tagName;
    }
}

