/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.server;

import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerDataItem;
import java.util.EnumMap;
import java.util.EnumSet;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerEntityData {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final String LOG_PREFIX = "[Custom Entity Data]";
    private static final EnumSet<ServerDataIndex> usedCustomDataAccessorIdSet = EnumSet.noneOf(ServerDataIndex.class);
    private static int customDataAccessorId = -1;
    private final EnumMap<ServerDataIndex, ServerDataItem<?>> customEntityDataMap = new EnumMap(ServerDataIndex.class);
    private final boolean isClientSide;

    public ServerEntityData(Entity entity) {
        this.isClientSide = entity != null && entity.m_9236_().f_46443_;
    }

    public static <T> ServerDataAccessor<T> defineId(EntityDataSerializer<T> entityDataSerializer) {
        if (customDataAccessorId >= 20) {
            log.error("{} No more custom data accessor available for {} with id {}The maximum for auto-generated ids is {}", (Object)LOG_PREFIX, entityDataSerializer, (Object)customDataAccessorId, (Object)20);
            return null;
        }
        log.warn("{} Please define a custom index for {} instead of using the auto-generated.", (Object)LOG_PREFIX, entityDataSerializer);
        return ServerEntityData.defineId(ServerDataIndex.getIndex(++customDataAccessorId), entityDataSerializer);
    }

    public static <T> ServerDataAccessor<T> defineId(ServerDataIndex serverDataIndex, EntityDataSerializer<T> entityDataSerializers) {
        if (usedCustomDataAccessorIdSet.contains((Object)serverDataIndex)) {
            log.error("{} Can't define custom data accessor {} with id {}, because it is already in use!", (Object)LOG_PREFIX, entityDataSerializers, (Object)serverDataIndex.ordinal());
            return null;
        }
        ServerDataAccessor<T> serverDataAccessor = new ServerDataAccessor<T>(serverDataIndex, entityDataSerializers);
        log.debug("{} Create custom data accessor {} with id {}", (Object)LOG_PREFIX, serverDataAccessor, (Object)serverDataIndex);
        usedCustomDataAccessorIdSet.add(serverDataIndex);
        return serverDataAccessor;
    }

    public <T> void define(ServerDataAccessor<T> serverDataAccessor, T customData) {
        if (!this.isClientSide) {
            ServerDataItem<T> dataItem = new ServerDataItem<T>(serverDataAccessor, customData);
            log.debug("{} Define custom data item {} with {}", (Object)LOG_PREFIX, dataItem, serverDataAccessor);
            this.customEntityDataMap.put(serverDataAccessor.getIndex(), dataItem);
        }
    }

    public <T> void set(ServerDataAccessor<T> entityDataAccessor, T customData) {
        ServerDataItem<T> serverDataItem = this.getDataItem(entityDataAccessor);
        if (serverDataItem != null) {
            log.debug("{} Set custom data {} for {} with id {}", (Object)LOG_PREFIX, serverDataItem, entityDataAccessor, (Object)entityDataAccessor.getIndex());
            serverDataItem.setValue(customData);
        }
    }

    public <T> T get(ServerDataAccessor<T> entityDataAccessor) {
        ServerDataItem<T> serverDataItem = this.getDataItem(entityDataAccessor);
        if (serverDataItem != null) {
            return serverDataItem.getValue();
        }
        return null;
    }

    private <T> ServerDataItem<T> getDataItem(ServerDataAccessor<T> entityDataAccessor) {
        try {
            ServerDataItem<?> serverDataItem = this.customEntityDataMap.get((Object)entityDataAccessor.getIndex());
            return serverDataItem;
        }
        catch (Exception exception) {
            log.error("{} Failed to get data item for {}:", (Object)LOG_PREFIX, entityDataAccessor, (Object)exception);
            return null;
        }
    }
}

