/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class Skeleton
extends EasyNPCBaseModelEntity<Skeleton> {
    public static final String ID = "skeleton";
    public static final String ID_STRAY = "stray";
    public static final String ID_WITHER_SKELETON = "wither_skeleton";

    public Skeleton(EntityType<? extends PathfinderMob> entityType, Level level) {
        this(entityType, level, Variant.SKELETON);
    }

    public Skeleton(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variant) {
        super(entityType, level, variant);
        this.getEntityAttributes().setEnvironmentalAttributes(this.getEntityAttributes().getEnvironmentalAttributes().withCanBreathUnderwater(true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0);
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.SKELETON;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.SKELETON;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        Variant soundVariant = Variant.valueOf(variantName);
        switch (soundVariant) {
            case STRAY: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12451_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12452_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12453_);
                soundDataSet.addSound(SoundType.STEP, SoundEvents.f_12454_);
                break;
            }
            case WITHER_SKELETON: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12559_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12560_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12561_);
                soundDataSet.addSound(SoundType.STEP, SoundEvents.f_12562_);
                break;
            }
            default: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.f_12423_);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12424_);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12381_);
                soundDataSet.addSound(SoundType.STEP, SoundEvents.f_12383_);
            }
        }
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.f_12508_);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.f_12509_);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.f_12507_);
        return soundDataSet;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public static enum Variant {
        SKELETON,
        STRAY,
        WITHER_SKELETON;

    }
}

