/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu;

import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationTypeHelper;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenuHandler;
import de.markusbordihn.easynpc.menu.dialog.DialogMenu;
import de.markusbordihn.easynpc.menu.dialog.DialogMenuHandler;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.menu.editor.EditorMenuHandler;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.MenuType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface MenuHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");

    default public void openConfigurationMenu(ConfigurationType configurationType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, int pageIndex) {
        ConfigurationType configurationTypeAlias = ConfigurationTypeHelper.resolveConfigurationTypeAlias(configurationType, easyNPC);
        MenuType<? extends ConfigurationMenu> menuType = this.getMenuTypeByConfigurationType(configurationTypeAlias);
        if (menuType == null) {
            log.error("Unknown configuration {} for {} from {}", (Object)configurationTypeAlias, easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = ConfigurationMenuHandler.getScreenData(configurationTypeAlias, easyNPC, serverPlayer, pageIndex);
        MenuProvider menuProvider = ConfigurationMenuHandler.getMenuProvider(configurationTypeAlias, easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.m_20148_();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    default public void openEditorMenu(EditorType editorType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, ActionEventType actionEventType, ConfigurationType configurationType, EditorType formerEditorType, int pageIndex) {
        CompoundTag additionalSyncData = new CompoundTag();
        AdditionalScreenData.addActionEventType(additionalSyncData, actionEventType);
        AdditionalScreenData.addConfigurationType(additionalSyncData, configurationType);
        AdditionalScreenData.addEditorType(additionalSyncData, formerEditorType);
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, dialogButtonId, actionDataEntryId, pageIndex, additionalSyncData);
    }

    default public void openEditorMenu(EditorType editorType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, null, null, pageIndex, new CompoundTag());
    }

    default public void openEditorMenu(EditorType editorType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, int pageIndex) {
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, dialogButtonId, null, pageIndex, new CompoundTag());
    }

    default public void openEditorMenu(EditorType editorType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, int pageIndex, CompoundTag additionalSyncData) {
        MenuType<? extends EditorMenu> menuType = this.getMenuTypeByEditorType(editorType);
        if (menuType == null) {
            log.error("Unknown editor {} for {} from {}", (Object)editorType, easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = EditorMenuHandler.getScreenData(editorType, easyNPC, dialogId, dialogButtonId, actionDataEntryId, pageIndex, additionalSyncData);
        MenuProvider menuProvider = EditorMenuHandler.getMenuProvider(editorType, easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.m_20148_();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    default public void openDialogMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        MenuType<? extends DialogMenu> menuType = this.getDialogMenuType();
        if (menuType == null) {
            log.error("Unknown dialog {} for {} from {}", menuType, easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = DialogMenuHandler.getScreenData(easyNPC, dialogId, pageIndex);
        MenuProvider menuProvider = DialogMenuHandler.getMenuProvider(easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.m_20148_();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    public MenuType<? extends ConfigurationMenu> getMenuTypeByConfigurationType(ConfigurationType var1);

    public MenuType<? extends EditorMenu> getMenuTypeByEditorType(EditorType var1);

    public MenuType<? extends DialogMenu> getDialogMenuType();
}

