/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.block.entity.BaseEasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.data.spawner.SpawnerSettingType;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public record ChangeSpawnerSettingMessage(BlockPos blockPos, SpawnerSettingType settingType, int settingValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_spawner_settings");

    public static ChangeSpawnerSettingMessage create(FriendlyByteBuf buffer) {
        return new ChangeSpawnerSettingMessage(buffer.m_130135_(), (SpawnerSettingType)buffer.m_130066_(SpawnerSettingType.class), buffer.readInt());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        buffer.m_130068_((Enum)this.settingType);
        buffer.writeInt(this.settingValue);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        ServerLevel serverLevel = serverPlayer.m_284548_();
        BlockEntity blockEntity = serverLevel.m_7702_(this.blockPos);
        if (blockEntity == null) {
            blockEntity = serverLevel.m_46745_(this.blockPos).m_5685_(this.blockPos, LevelChunk.EntityCreationType.IMMEDIATE);
        }
        if (!(blockEntity instanceof BaseEasyNPCSpawnerBlockEntity)) {
            log.error("Found {}({}) instead of NPC spawner block entity at {}", (Object)blockEntity, (Object)serverLevel.m_8055_(this.blockPos), (Object)this.blockPos);
            return;
        }
        BaseEasyNPCSpawnerBlockEntity spawnerBlockEntity = (BaseEasyNPCSpawnerBlockEntity)blockEntity;
        if (!serverPlayer.m_7500_() && spawnerBlockEntity.getOwner() != null && !spawnerBlockEntity.getOwner().equals(serverPlayer.m_20148_())) {
            log.warn("Player {} has no permission to change the settings of spawner at {}", (Object)serverPlayer.m_7755_().getString(), (Object)this.blockPos);
            return;
        }
        switch (this.settingType) {
            case SPAWN_RANGE: {
                log.debug("Set spawner {} spawn range to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setSpawnRange(this.settingValue);
                break;
            }
            case DESPAWN_RANGE: {
                log.debug("Set spawner {} despawn range to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setDespawnRange(this.settingValue);
                break;
            }
            case REQUIRED_PLAYER_RANGE: {
                log.debug("Set spawner {} required player range to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setRequiredPlayerRange(this.settingValue);
                break;
            }
            case DELAY: {
                log.debug("Set spawner {} delay to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setDelay(this.settingValue);
                break;
            }
            case MAX_NEARBY_ENTITIES: {
                log.debug("Set spawner {} max nearby entities to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setMaxNearbyEntities(this.settingValue);
                break;
            }
            case SPAWN_COUNT: {
                log.debug("Set spawner {} spawn count to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setSpawnCount(this.settingValue);
                break;
            }
            default: {
                log.error("Unknown spawner setting type {} for {}", (Object)this.settingType, (Object)spawnerBlockEntity);
            }
        }
    }
}

