/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.embedded.ca.solostudios.stringsimilarity;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.MetricStringDistance;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/Levenshtein;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/MetricStringDistance;", "()V", "distance", "", "s1", "", "s2", "limit", "", "kt-string-similarity"})
public final class Levenshtein
implements MetricStringDistance {
    @Override
    public double distance(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        return this.distance(s1, s2, Integer.MAX_VALUE);
    }

    public final double distance(@NotNull String s1, @NotNull String s2, int limit) {
        int i;
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (Intrinsics.areEqual((Object)s1, (Object)s2)) {
            return 0.0;
        }
        CharSequence charSequence = s1;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return s2.length();
        }
        charSequence = s2;
        bl = false;
        if (charSequence.length() == 0) {
            return s1.length();
        }
        int[] v0 = new int[s2.length() + 1];
        int[] v1 = new int[s2.length() + 1];
        int[] vtemp = null;
        int n = 0;
        int n2 = v0.length + -1;
        if (n <= n2) {
            do {
                v0[i] = i = n++;
            } while (n <= n2);
        }
        if ((n = 0) <= (n2 = s1.length() + -1)) {
            do {
                i = n++;
                v1[0] = i + 1;
                int minv1 = v1[0];
                int n3 = 0;
                int n4 = s2.length() + -1;
                if (n3 <= n4) {
                    do {
                        int j = n3++;
                        int cost = 1;
                        if (s1.charAt(i) == s2.charAt(j)) {
                            cost = 0;
                        }
                        int n5 = v1[j] + 1;
                        int n6 = v0[j + 1] + 1;
                        int n7 = v0[j] + cost;
                        boolean bl2 = false;
                        n6 = Math.min(n6, n7);
                        n7 = 0;
                        v1[j + 1] = Math.min(n5, n6);
                        n5 = v1[j + 1];
                        n6 = 0;
                        minv1 = Math.min(minv1, n5);
                    } while (n3 <= n4);
                }
                if (minv1 >= limit) {
                    return limit;
                }
                vtemp = v0;
                v0 = v1;
                v1 = vtemp;
            } while (n <= n2);
        }
        return v0[s2.length()];
    }

    public static /* synthetic */ double distance$default(Levenshtein levenshtein, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return levenshtein.distance(string, string2, n);
    }
}

