/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model.part;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import xaero.common.misc.Misc;

public class ModelPartUtil {
    private static final Field CUBES_FIELD = Misc.getFieldReflection(ModelPart.class, "cubes", "field_3663", "Ljava/util/List;", "f_104212_");
    private static final Field CHILDREN_FIELD = Misc.getFieldReflection(ModelPart.class, "children", "field_3661", "Ljava/util/Map;", "f_104213_");

    public static List<ModelPart.Cube> getCubes(ModelPart modelRenderer) {
        return (List)Misc.getReflectFieldValue(modelRenderer, CUBES_FIELD);
    }

    public static Map<String, ModelPart> getChildren(ModelPart modelRenderer) {
        return (Map)Misc.getReflectFieldValue(modelRenderer, CHILDREN_FIELD);
    }

    public static boolean hasDirectCubes(ModelPart part) {
        List<ModelPart.Cube> cubes = ModelPartUtil.getCubes(part);
        return cubes != null && !cubes.isEmpty();
    }

    public static boolean hasCubes(ModelPart part) {
        if (ModelPartUtil.hasDirectCubes(part)) {
            return true;
        }
        Map<String, ModelPart> children = ModelPartUtil.getChildren(part);
        for (ModelPart child : children.values()) {
            if (!ModelPartUtil.hasCubes(child)) continue;
            return true;
        }
        return false;
    }

    public static ModelPart.Cube getBiggestCuboid(ModelPart part) {
        List<ModelPart.Cube> mainCubeList = ModelPartUtil.getCubes(part);
        if (mainCubeList == null) {
            return null;
        }
        if (mainCubeList.isEmpty()) {
            return null;
        }
        float biggestSize = 0.0f;
        ModelPart.Cube biggestCuboid = null;
        for (ModelPart.Cube cuboid : mainCubeList) {
            float size = Math.abs((cuboid.f_104338_ - cuboid.f_104335_) * (cuboid.f_104339_ - cuboid.f_104336_) * (cuboid.f_104340_ - cuboid.f_104337_));
            if (!(size >= biggestSize)) continue;
            biggestCuboid = cuboid;
            biggestSize = size;
        }
        return biggestCuboid;
    }
}

