/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.stamina.StaminaFactory;
import tictim.paraglider.api.vessel.VesselContainer;

public class ParagliderAPI {
    public static final String MODID = "paraglider";
    private static Function<@NotNull Player, @NotNull Movement> movementSupplier;
    private static Function<@NotNull Player, @NotNull Stamina> staminaSupplier;
    private static Function<@NotNull Player, @NotNull VesselContainer> vesselContainerSupplier;
    private static StaminaFactory staminaFactory;

    @NotNull
    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }

    @ApiStatus.Internal
    @NotNull
    public static Function<Player, Movement> movementSupplier() {
        if (movementSupplier != null) {
            return movementSupplier;
        }
        throw new IllegalStateException("movementSupplier is not available yet");
    }

    @ApiStatus.Internal
    @NotNull
    public static Function<Player, Stamina> staminaSupplier() {
        if (staminaSupplier != null) {
            return staminaSupplier;
        }
        throw new IllegalStateException("staminaSupplier is not available yet");
    }

    @ApiStatus.Internal
    @NotNull
    public static Function<Player, VesselContainer> vesselContainerSupplier() {
        if (vesselContainerSupplier != null) {
            return vesselContainerSupplier;
        }
        throw new IllegalStateException("vesselContainerSupplier is not available yet");
    }

    @ApiStatus.Internal
    @NotNull
    public static StaminaFactory staminaFactory() {
        if (staminaFactory != null) {
            return staminaFactory;
        }
        throw new IllegalStateException("staminaFactory is not available yet");
    }

    @ApiStatus.Internal
    public static void setMovementSupplier(@NotNull Function<Player, Movement> supplier) {
        Objects.requireNonNull(supplier);
        if (movementSupplier != null) {
            throw new IllegalStateException("Trying to set movementSupplier twice");
        }
        movementSupplier = supplier;
    }

    @ApiStatus.Internal
    public static void setStaminaSupplier(@NotNull Function<Player, Stamina> supplier) {
        Objects.requireNonNull(supplier);
        if (staminaSupplier != null) {
            throw new IllegalStateException("Trying to set staminaSupplier twice");
        }
        staminaSupplier = supplier;
    }

    @ApiStatus.Internal
    public static void setVesselContainerSupplier(@NotNull Function<Player, VesselContainer> supplier) {
        Objects.requireNonNull(supplier);
        if (vesselContainerSupplier != null) {
            throw new IllegalStateException("Trying to set vesselContainerSupplier twice");
        }
        vesselContainerSupplier = supplier;
    }

    @ApiStatus.Internal
    public static void setStaminaFactory(@NotNull StaminaFactory staminaFactory) {
        Objects.requireNonNull(staminaFactory);
        if (ParagliderAPI.staminaFactory != null) {
            throw new IllegalStateException("Trying to set staminaFactory twice");
        }
        ParagliderAPI.staminaFactory = staminaFactory;
    }
}

