/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.objectweb.asm.Type;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.MovementPlugin;
import tictim.paraglider.api.plugin.ParagliderPlugin;
import tictim.paraglider.api.plugin.ParagliderPluginBase;
import tictim.paraglider.api.plugin.PluginInstance;
import tictim.paraglider.api.stamina.StaminaPlugin;
import tictim.paraglider.plugin.ParagliderPluginLoader;

public final class ForgeParagliderPluginLoader
implements ParagliderPluginLoader {
    private static final ForgeParagliderPluginLoader instance = new ForgeParagliderPluginLoader();
    private static final Type annotationType = Type.getType(ParagliderPlugin.class);
    private static final Class<?>[] allPluginTypes = new Class[]{StaminaPlugin.class, MovementPlugin.class};
    private boolean initialized;
    private final List<PluginInstance<StaminaPlugin>> staminaPlugins = new ArrayList<PluginInstance<StaminaPlugin>>();
    private final List<PluginInstance<MovementPlugin>> movementPlugins = new ArrayList<PluginInstance<MovementPlugin>>();

    private ForgeParagliderPluginLoader() {
    }

    @NotNull
    public static ForgeParagliderPluginLoader get() {
        return instance;
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull PluginInstance<StaminaPlugin>> getStaminaPlugins() {
        this.checkAndInitialize();
        return Collections.unmodifiableList(this.staminaPlugins);
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull PluginInstance<MovementPlugin>> getMovementPlugins() {
        this.checkAndInitialize();
        return Collections.unmodifiableList(this.movementPlugins);
    }

    private void checkAndInitialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        ArrayList<PluginInstance<ParagliderPluginBase>> plugins = new ArrayList<PluginInstance<ParagliderPluginBase>>();
        for (ModFileScanData modFileScanData : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotation : modFileScanData.getAnnotations()) {
                Class<?> clazz;
                if (!annotationType.equals((Object)annotation.annotationType())) continue;
                try {
                    clazz = Class.forName(annotation.clazz().getClassName(), true, ForgeParagliderPluginLoader.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    ParagliderMod.LOGGER.debug("Failed to load plugin {}: ", (Object)annotation.clazz().getClassName(), (Object)e);
                    continue;
                }
                if (!ForgeParagliderPluginLoader.checkPluginType(clazz)) {
                    ParagliderMod.LOGGER.debug("Plugin {} doesn't implement any of the available plugin types; available plugin types are:\n  {}", clazz, (Object)Arrays.stream(allPluginTypes).map(c -> c.getCanonicalName()).collect(Collectors.joining("\n  ")));
                    continue;
                }
                try {
                    String modID = ForgeParagliderPluginLoader.getModID(modFileScanData);
                    plugins.add(new PluginInstance<ParagliderPluginBase>((ParagliderPluginBase)clazz.getConstructor(new Class[0]).newInstance(new Object[0]), modID));
                    if (modID != null) {
                        ParagliderMod.LOGGER.debug("Loaded plugin {} associated with mod {}", clazz, (Object)modID);
                        continue;
                    }
                    ParagliderMod.LOGGER.debug("Loaded plugin {}", clazz);
                    ParagliderMod.LOGGER.warn("Cannot read mod ID associated to plugin {}", clazz);
                }
                catch (InstantiationException | InvocationTargetException e) {
                    ParagliderMod.LOGGER.debug("Failed to load plugin {}: ", clazz, (Object)e);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    ParagliderMod.LOGGER.debug("Failed to load plugin {}: Constructor not available", clazz);
                }
            }
        }
        ParagliderMod.LOGGER.debug("Loaded {} plugins total", (Object)plugins.size());
        for (PluginInstance pluginInstance : plugins) {
            if (pluginInstance.instance() instanceof StaminaPlugin) {
                this.staminaPlugins.add(pluginInstance.cast(StaminaPlugin.class));
            }
            if (!(pluginInstance.instance() instanceof MovementPlugin)) continue;
            this.movementPlugins.add(pluginInstance.cast(MovementPlugin.class));
        }
    }

    private static boolean checkPluginType(@NotNull Class<?> clazz) {
        for (Class<?> c : allPluginTypes) {
            if (!c.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getModID(ModFileScanData scanData) {
        List data = scanData.getIModInfoData();
        if (data.isEmpty()) {
            return null;
        }
        List modInfo = ((IModFileInfo)data.get(0)).getMods();
        if (modInfo.isEmpty()) {
            return null;
        }
        return ((IModInfo)modInfo.get(0)).getModId();
    }
}

