/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge.contents.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.item.ParagliderItem;

public class ParagliderLoot
extends LootModifier {
    public static final Codec<ParagliderLoot> CODEC = RecordCodecBuilder.create(b -> b.group((App)Codec.BOOL.fieldOf("dekuLeaf").forGetter(m -> m.dekuLeaf)).and(ParagliderLoot.codecStart((RecordCodecBuilder.Instance)b).t1()).apply((Applicative)b, ParagliderLoot::new));
    public final boolean dekuLeaf;

    public ParagliderLoot(boolean dekuLeaf, LootItemCondition ... conditions) {
        super(conditions);
        this.dekuLeaf = dekuLeaf;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        Cfg.TotwCompatConfigOption configOption = Cfg.get().paragliderInTowersOfTheWild();
        if (configOption != Cfg.TotwCompatConfigOption.DISABLE) {
            ParagliderItem item = configOption == Cfg.TotwCompatConfigOption.DEKU_LEAF_ONLY || configOption != Cfg.TotwCompatConfigOption.PARAGLIDER_ONLY && this.dekuLeaf ? Contents.get().dekuLeaf() : Contents.get().paraglider();
            ItemStack stack = new ItemStack((ItemLike)item);
            if (context.m_230907_().m_188499_()) {
                stack = DyeableLeatherItem.m_41118_((ItemStack)stack, Arrays.asList(DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)context.m_230907_().m_188503_(16))), DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)context.m_230907_().m_188503_(16)))));
            }
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    @NotNull
    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

