/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge.proxy;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.client.ParagliderItemColor;
import tictim.paraglider.client.ParagliderItemProperty;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.forge.client.StaminaWheelOverlay;
import tictim.paraglider.forge.proxy.CommonProxy;
import tictim.paraglider.impl.movement.PlayerStateMap;

public class ClientProxy
extends CommonProxy {
    private final ParagliderClientSettings clientSettings = new ParagliderClientSettings(FMLPaths.GAMEDIR.get());
    @Nullable
    private PlayerStateMap syncedStateMap;
    @Nullable
    private KeyMapping paragliderSettingsKey;

    public ClientProxy() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(e -> e.enqueueWork(() -> {
            ItemProperties.register((Item)Contents.get().paraglider(), (ResourceLocation)ParagliderItemProperty.KEY_PARAGLIDING, (ItemPropertyFunction)ParagliderItemProperty.get());
            ItemProperties.register((Item)Contents.get().dekuLeaf(), (ResourceLocation)ParagliderItemProperty.KEY_PARAGLIDING, (ItemPropertyFunction)ParagliderItemProperty.get());
        }));
        eventBus.addListener(e -> {
            this.paragliderSettingsKey = new KeyMapping("key.paraglider.paragliderSettings", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 80, "key.categories.misc");
            e.register(this.paragliderSettingsKey);
        });
        eventBus.addListener(e -> {
            e.register((ItemColor)new ParagliderItemColor(Contents.get().paraglider()), new ItemLike[]{Contents.get().paraglider()});
            e.register((ItemColor)new ParagliderItemColor(Contents.get().dekuLeaf()), new ItemLike[]{Contents.get().dekuLeaf()});
        });
        eventBus.addListener(e -> e.registerAboveAll("stamina_wheel", (IGuiOverlay)new StaminaWheelOverlay()));
        this.clientSettings.load();
    }

    @Override
    protected void onServerAboutToStart(ServerAboutToStartEvent event) {
        super.onServerAboutToStart(event);
        this.syncedStateMap = null;
    }

    @Override
    @NotNull
    public ParagliderClientSettings getClientSettings() {
        return this.clientSettings;
    }

    @Override
    @NotNull
    public PlayerStateMap getStateMap() {
        return this.syncedStateMap != null ? this.syncedStateMap : super.getStateMap();
    }

    @Override
    public void setSyncedStateMap(@Nullable PlayerStateMap stateMap) {
        this.syncedStateMap = stateMap;
    }

    @Override
    @NotNull
    public KeyMapping getParagliderSettingsKey() {
        if (this.paragliderSettingsKey == null) {
            throw new IllegalStateException("paragliderSettingsKey is not available yet");
        }
        return this.paragliderSettingsKey;
    }
}

