/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class ClearRecastsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clearRecasts").requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)"all").executes(context -> ClearRecastsCommand.clearRecast((CommandSourceStack)context.getSource(), null)))).then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> ClearRecastsCommand.clearRecast((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"))))));
    }

    private static int clearRecast(CommandSourceStack source, @Nullable Collection<ServerPlayer> targets) {
        if (targets != null && !targets.isEmpty()) {
            targets.forEach(ClearRecastsCommand::removeRecastForPlayer);
            if (!targets.isEmpty()) {
                source.m_288197_(() -> Component.m_237115_((String)"commands.clearRecast.success"), true);
            }
            return targets.size();
        }
        source.m_81377_().m_129785_().forEach(level -> level.m_8795_(player -> true).forEach(ClearRecastsCommand::removeRecastForPlayer));
        source.m_288197_(() -> Component.m_237115_((String)"commands.clearRecast.success"), true);
        return 1;
    }

    private static void removeRecastForPlayer(ServerPlayer serverPlayer) {
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        PlayerRecasts playerRecasts = magicData.getPlayerRecasts();
        playerRecasts.getAllRecasts().forEach(recastInstance -> playerRecasts.removeRecast((RecastInstance)recastInstance, RecastResult.COMMAND));
    }
}

