/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.util;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.player.ClientInputEvents;
import io.redspace.ironsspellbooks.spells.eldritch.AbstractEldritchSpell;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TooltipsUtils {
    public static final Style UNIQUE_STYLE = Style.f_131099_.m_178520_(14697252);
    private static final Style INFO_STYLE = Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN);
    private static final Style OBFUSCATED_STYLE = AbstractEldritchSpell.ELDRITCH_OBFUSCATED_STYLE.m_131146_(INFO_STYLE);

    public static int indexOfComponent(List<Component> lines, String key) {
        return TooltipsUtils.indexOfInternal(lines, key::equals);
    }

    public static int indexOfComponentRegex(List<Component> lines, String regex) {
        return TooltipsUtils.indexOfInternal(lines, string -> string.matches(regex));
    }

    public static int indexOfAdvancedText(List<Component> lines, ItemStack itemStack) {
        return TooltipsUtils.indexOfComponentRegex(lines, "item.durability|item.nbt_tags|" + ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()));
    }

    private static int indexOfInternal(List<Component> lines, Predicate<String> comparator) {
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            LiteralContents literalContents;
            TranslatableContents translatableContents;
            Component component = lines.get(i);
            ComponentContents componentContents = component.m_214077_();
            if (!(componentContents instanceof TranslatableContents ? comparator.test((translatableContents = (TranslatableContents)componentContents).m_237508_()) : (componentContents = component.m_214077_()) instanceof LiteralContents && comparator.test((literalContents = (LiteralContents)componentContents).f_237368_()))) continue;
            return i;
        }
        return -1;
    }

    public static List<MutableComponent> formatActiveSpellTooltip(ItemStack stack, SpellData spellData, CastSource castSource, @Nonnull LocalPlayer player) {
        AbstractSpell spell = spellData.getSpell();
        int spellLevel = spell.getLevelFor(spellData.getLevel(), (LivingEntity)player);
        MutableComponent title = TooltipsUtils.getTitleComponent(spellData, player);
        List<MutableComponent> uniqueInfo = spell.getUniqueInfo(spellLevel, (LivingEntity)player);
        MutableComponent manaCost = TooltipsUtils.getManaCostComponent(spell.getCastType(), spell.getManaCost(spellLevel)).m_130940_(ChatFormatting.BLUE);
        MutableComponent cooldownTime = Component.m_237110_((String)"tooltip.irons_spellbooks.cooldown_length_seconds", (Object[])new Object[]{Utils.timeFromTicks(MagicManager.getEffectiveSpellCooldown(spell, (Player)player, castSource), 2)}).m_130940_(ChatFormatting.BLUE);
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(Component.m_237119_());
        lines.add(title);
        uniqueInfo.forEach(line -> lines.add(Component.m_237113_((String)" ").m_7220_((Component)line.m_130948_(TooltipsUtils.getStyleFor((Player)player, spell)))));
        if (spell.getCastType() != CastType.INSTANT) {
            lines.add(Component.m_237113_((String)" ").m_7220_((Component)TooltipsUtils.getCastTimeComponent(spell.getCastType(), Utils.timeFromTicks(spell.getEffectiveCastTime(spellLevel, (LivingEntity)player), 2)).m_130940_(ChatFormatting.BLUE)));
        }
        if (castSource != CastSource.SWORD || ((Boolean)ServerConfigs.SWORDS_CONSUME_MANA.get()).booleanValue()) {
            lines.add(manaCost);
        }
        if (castSource != CastSource.SWORD || ((Double)ServerConfigs.SWORDS_CD_MULTIPLIER.get()).floatValue() > 0.0f) {
            lines.add(cooldownTime);
        }
        return lines;
    }

    public static List<Component> formatScrollTooltip(ItemStack stack, @Nonnull LocalPlayer player) {
        if (stack.m_41720_() instanceof Scroll) {
            ISpellContainer spellList = ISpellContainer.get(stack);
            if (spellList.isEmpty()) {
                return List.of();
            }
            SpellData spellData = spellList.getSpellAtIndex(0);
            AbstractSpell spell = spellData.getSpell();
            int spellLevel = spell.getLevelFor(spellData.getLevel(), (LivingEntity)player);
            MutableComponent levelText = TooltipsUtils.getLevelComponenet(spellData, (LivingEntity)player);
            MutableComponent title = Component.m_237110_((String)"tooltip.irons_spellbooks.level", (Object[])new Object[]{levelText}).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"tooltip.irons_spellbooks.rarity", (Object[])new Object[]{spell.getRarity(spellData.getLevel()).getDisplayName()}).m_130948_(spell.getRarity(spellData.getLevel()).getDisplayName().m_7383_())).m_130940_(ChatFormatting.GRAY);
            List<MutableComponent> uniqueInfo = spell.getUniqueInfo(spellLevel, (LivingEntity)player);
            MutableComponent whenInSpellBook = Component.m_237115_((String)"tooltip.irons_spellbooks.scroll_tooltip").m_130940_(ChatFormatting.GRAY);
            MutableComponent manaCost = TooltipsUtils.getManaCostComponent(spell.getCastType(), spell.getManaCost(spellLevel)).m_130940_(ChatFormatting.BLUE);
            MutableComponent cooldownTime = Component.m_237110_((String)"tooltip.irons_spellbooks.cooldown_length_seconds", (Object[])new Object[]{Utils.timeFromTicks(MagicManager.getEffectiveSpellCooldown(spell, (Player)player, CastSource.SCROLL), 2)}).m_130940_(ChatFormatting.BLUE);
            MutableComponent castType = null;
            if (spell.getCastType() != CastType.INSTANT) {
                castType = Component.m_237113_((String)" ").m_7220_((Component)TooltipsUtils.getCastTimeComponent(spell.getCastType(), Utils.timeFromTicks(spell.getEffectiveCastTime(spellLevel, (LivingEntity)player), 2)).m_130940_(ChatFormatting.BLUE));
            }
            ArrayList<Component> lines = new ArrayList<Component>();
            lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)title));
            uniqueInfo.forEach(line -> lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)line.m_130948_(TooltipsUtils.getStyleFor((Player)player, spell)))));
            if (castType != null) {
                lines.add((Component)castType);
            }
            lines.add((Component)Component.m_237119_());
            lines.add((Component)whenInSpellBook);
            lines.add((Component)manaCost);
            lines.add((Component)cooldownTime);
            lines.add((Component)spell.getSchoolType().getDisplayName().m_6881_());
            return lines;
        }
        return List.of();
    }

    public static void addShiftTooltip(List<Component> currentTooltip, List<Component> tooltipToAdd) {
        TooltipsUtils.addShiftTooltip(currentTooltip, (Component)Component.m_237115_((String)"tooltip.irons_spellbooks.shift_tooltip").m_130940_(ChatFormatting.GRAY), tooltipToAdd);
    }

    public static void addShiftTooltip(List<Component> currentTooltip, Component shiftHeader, List<Component> tooltipToAdd) {
        if (ClientInputEvents.isShiftKeyDown) {
            currentTooltip.addAll(tooltipToAdd);
        } else {
            currentTooltip.add(shiftHeader);
        }
    }

    public static MutableComponent getLevelComponenet(SpellData spellData, LivingEntity caster) {
        int levelTotal = spellData.getSpell().getLevelFor(spellData.getLevel(), caster);
        int diff = levelTotal - spellData.getLevel();
        if (diff > 0) {
            return Component.m_237110_((String)"tooltip.irons_spellbooks.level_plus", (Object[])new Object[]{levelTotal, diff});
        }
        if (diff < 0) {
            return Component.m_237110_((String)"tooltip.irons_spellbooks.level_minus", (Object[])new Object[]{levelTotal, diff});
        }
        return Component.m_237113_((String)String.valueOf(levelTotal));
    }

    public static MutableComponent getCastTimeComponent(CastType type, String castTime) {
        return switch (type) {
            case CastType.CONTINUOUS -> Component.m_237110_((String)"tooltip.irons_spellbooks.cast_continuous", (Object[])new Object[]{castTime});
            case CastType.LONG -> Component.m_237110_((String)"tooltip.irons_spellbooks.cast_long", (Object[])new Object[]{castTime});
            default -> Component.m_237115_((String)"ui.irons_spellbooks.cast_instant");
        };
    }

    public static MutableComponent getManaCostComponent(CastType castType, int manaCost) {
        if (castType == CastType.CONTINUOUS) {
            return Component.m_237110_((String)"tooltip.irons_spellbooks.mana_cost_per_second", (Object[])new Object[]{manaCost * 2});
        }
        return Component.m_237110_((String)"tooltip.irons_spellbooks.mana_cost", (Object[])new Object[]{manaCost});
    }

    public static MutableComponent getTitleComponent(SpellData spellData, @NotNull LocalPlayer player) {
        MutableComponent levelText = TooltipsUtils.getLevelComponenet(spellData, (LivingEntity)player);
        AbstractSpell spell = spellData.getSpell();
        return Component.m_237110_((String)"tooltip.irons_spellbooks.selected_spell", (Object[])new Object[]{spell.getDisplayName((Player)player), levelText}).m_130948_(spell.getSchoolType().getDisplayName().m_7383_());
    }

    public static List<FormattedCharSequence> createSpellDescriptionTooltip(AbstractSpell spell, Font font) {
        Player player = MinecraftInstanceHelper.instance.player();
        MutableComponent name = spell.getDisplayName(player);
        List description = font.m_92923_((FormattedText)Component.m_237115_((String)String.format("%s.guide", spell.getComponentId())).m_130940_(ChatFormatting.GRAY), 180);
        ArrayList<FormattedCharSequence> hoverText = new ArrayList<FormattedCharSequence>();
        hoverText.add(FormattedCharSequence.m_13714_((String)name.getString(), (Style)name.m_7383_().m_131162_(Boolean.valueOf(true))));
        if (!spell.obfuscateStats(player)) {
            hoverText.addAll(description);
        }
        return hoverText;
    }

    public static Style getStyleFor(Player player, AbstractSpell spell) {
        return spell.obfuscateStats(player) ? OBFUSCATED_STYLE : INFO_STYLE;
    }
}

