/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.behaviour.dispenser;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.simibubi.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.item.ItemHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class DropperMovementBehaviour
implements MovementBehaviour {
    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.f_46443_) {
            return;
        }
        MountedItemStorage storage = context.getItemStorage();
        if (storage == null) {
            return;
        }
        int slot = DropperMovementBehaviour.getSlot(storage, context.world.f_46441_, (IItemHandler)context.contraption.getStorage().getAllItems());
        if (slot == -1) {
            DropperMovementBehaviour.failDispense(context, pos);
            return;
        }
        ItemStack stack = storage.getStackInSlot(slot).m_41777_();
        MountedDispenseBehavior behavior = this.getDispenseBehavior(context, pos, stack);
        ItemStack remainder = behavior.dispense(stack, context, pos);
        storage.setStackInSlot(slot, remainder);
    }

    protected MountedDispenseBehavior getDispenseBehavior(MovementContext context, BlockPos pos, ItemStack stack) {
        return DefaultMountedDispenseBehavior.INSTANCE;
    }

    private static int getSlot(MountedItemStorage storage, RandomSource random, IItemHandler contraptionInventory) {
        IntArrayList filledSlots = new IntArrayList();
        for (int i = 0; i < storage.getSlots(); ++i) {
            ItemStack stack = storage.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41613_() == 1 && stack.m_41741_() != 1) {
                if ((stack = DropperMovementBehaviour.tryTopOff(stack, contraptionInventory)) == null) continue;
                storage.setStackInSlot(i, stack);
            }
            filledSlots.add(i);
        }
        return switch (filledSlots.size()) {
            case 0 -> -1;
            case 1 -> filledSlots.getInt(0);
            default -> (Integer)Util.m_214621_((List)filledSlots, (RandomSource)random);
        };
    }

    @Nullable
    private static ItemStack tryTopOff(ItemStack stack, IItemHandler from) {
        Predicate<ItemStack> test = otherStack -> ItemStack.m_150942_((ItemStack)stack, (ItemStack)otherStack);
        int needed = stack.m_41741_() - stack.m_41613_();
        ItemStack extracted = ItemHelper.extract(from, test, ItemHelper.ExtractionCountMode.UPTO, needed, false);
        return extracted.m_41619_() ? null : stack.m_255036_(stack.m_41613_() + extracted.m_41613_());
    }

    private static void failDispense(MovementContext ctx, BlockPos pos) {
        ctx.world.m_46796_(1001, pos, 0);
    }
}

