/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper;

import com.simibubi.create.AllPackets;
import com.simibubi.create.content.equipment.zapper.ShootGadgetPacket;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class ShootableGadgetItemMethods {
    public static void applyCooldown(Player player, ItemStack item, InteractionHand hand, Predicate<ItemStack> predicate, int cooldown) {
        if (cooldown <= 0) {
            return;
        }
        boolean gunInOtherHand = predicate.test(player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND));
        player.m_36335_().m_41524_(item.m_41720_(), gunInOtherHand ? cooldown * 2 / 3 : cooldown);
    }

    public static void sendPackets(Player player, Function<Boolean, ? extends ShootGadgetPacket> factory) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)factory.apply(false));
        AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)factory.apply(true));
    }

    public static boolean shouldSwap(Player player, ItemStack item, InteractionHand hand, Predicate<ItemStack> predicate) {
        boolean isSwap = item.m_41783_().m_128441_("_Swap");
        boolean mainHand = hand == InteractionHand.MAIN_HAND;
        boolean gunInOtherHand = predicate.test(player.m_21120_(mainHand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND));
        if (mainHand && isSwap && gunInOtherHand) {
            return true;
        }
        if (mainHand && !isSwap && gunInOtherHand) {
            item.m_41783_().m_128379_("_Swap", true);
        }
        if (!mainHand && isSwap) {
            item.m_41783_().m_128473_("_Swap");
        }
        if (!mainHand && gunInOtherHand) {
            player.m_21120_(InteractionHand.MAIN_HAND).m_41783_().m_128473_("_Swap");
        }
        player.m_6672_(hand);
        return false;
    }

    public static Vec3 getGunBarrelVec(Player player, boolean mainHand, Vec3 rightHandForward) {
        Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        float yaw = (float)((double)(player.m_146908_() / -180.0f) * Math.PI);
        float pitch = (float)((double)(player.m_146909_() / -180.0f) * Math.PI);
        int flip = mainHand == (player.m_5737_() == HumanoidArm.RIGHT) ? -1 : 1;
        Vec3 barrelPosNoTransform = new Vec3((double)flip * rightHandForward.f_82479_, rightHandForward.f_82480_, rightHandForward.f_82481_);
        Vec3 barrelPos = start.m_82549_(barrelPosNoTransform.m_82496_(pitch).m_82524_(yaw));
        return barrelPos;
    }
}

