/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.redstoneRequester;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class RedstoneRequesterConfigurationPacket
extends BlockEntityConfigurationPacket<RedstoneRequesterBlockEntity> {
    private String address;
    private boolean allowPartial;
    private List<Integer> amounts;

    public RedstoneRequesterConfigurationPacket(BlockPos pos, String address, boolean allowPartial, List<Integer> amounts) {
        super(pos);
        this.address = address;
        this.allowPartial = allowPartial;
        this.amounts = amounts;
    }

    public RedstoneRequesterConfigurationPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.address);
        buffer.writeBoolean(this.allowPartial);
        buffer.m_130130_(this.amounts.size());
        this.amounts.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130130_(arg_0));
    }

    @Override
    protected void readSettings(FriendlyByteBuf buffer) {
        this.address = buffer.m_130277_();
        this.allowPartial = buffer.readBoolean();
        int size = buffer.m_130242_();
        this.amounts = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            this.amounts.add(buffer.m_130242_());
        }
    }

    @Override
    protected void applySettings(RedstoneRequesterBlockEntity be) {
        be.encodedTargetAdress = this.address;
        List<BigItemStack> stacks = be.encodedRequest.stacks();
        for (int i = 0; i < stacks.size() && i < this.amounts.size(); ++i) {
            ItemStack stack = stacks.get((int)i).stack;
            if (stack.m_41619_()) continue;
            stacks.set(i, new BigItemStack(stack, this.amounts.get(i)));
        }
        if (!be.encodedRequest.orderedStacksMatchOrderedRecipes()) {
            be.encodedRequest = PackageOrderWithCrafts.simple(be.encodedRequest.stacks());
        }
        be.allowPartialRequests = this.allowPartial;
    }
}

