/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.stockTicker;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiEffectPacket;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlock;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PackageOrderRequestPacket
extends BlockEntityConfigurationPacket<StockTickerBlockEntity> {
    private PackageOrderWithCrafts order;
    private String address;
    private boolean encodeRequester;

    public PackageOrderRequestPacket(BlockPos pos, PackageOrderWithCrafts order, String address, boolean encodeRequester) {
        super(pos);
        this.order = order;
        this.address = address;
        this.encodeRequester = encodeRequester;
    }

    public PackageOrderRequestPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.address);
        this.order.write(buffer);
        buffer.writeBoolean(this.encodeRequester);
    }

    @Override
    protected void readSettings(FriendlyByteBuf buffer) {
        this.address = buffer.m_130277_();
        this.order = PackageOrderWithCrafts.read(buffer);
        this.encodeRequester = buffer.readBoolean();
    }

    @Override
    protected void applySettings(StockTickerBlockEntity be) {
    }

    @Override
    protected void applySettings(ServerPlayer player, StockTickerBlockEntity be) {
        if (this.encodeRequester) {
            if (!this.order.isEmpty()) {
                AllSoundEvents.CONFIRM.playOnServer(be.m_58904_(), (Vec3i)this.pos);
            }
            player.m_6915_();
            RedstoneRequesterBlock.programRequester(player, be, this.order, this.address);
            return;
        }
        if (!this.order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_REQUEST.playOnServer(be.m_58904_(), (Vec3i)this.pos);
            AllAdvancements.STOCK_TICKER.awardTo((Player)player);
            WiFiEffectPacket.send(player.m_9236_(), this.pos);
        }
        be.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, this.order, null, this.address);
    }
}

