/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.graph;

import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackMaterial;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TrackNodeLocation
extends Vec3i {
    public ResourceKey<Level> dimension;
    public int yOffsetPixels;

    public TrackNodeLocation(Vec3 vec) {
        this(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public TrackNodeLocation(double x, double y, double z) {
        super(Mth.m_14143_((float)Math.round(x * 2.0)), Mth.m_14107_((double)y) * 2, Mth.m_14143_((float)Math.round(z * 2.0)));
    }

    public TrackNodeLocation in(Level level) {
        return this.in((ResourceKey<Level>)level.m_46472_());
    }

    public TrackNodeLocation in(ResourceKey<Level> dimension) {
        this.dimension = dimension;
        return this;
    }

    private static TrackNodeLocation fromPackedPos(BlockPos bufferPos) {
        return new TrackNodeLocation(bufferPos);
    }

    private TrackNodeLocation(BlockPos readBlockPos) {
        super(readBlockPos.m_123341_(), readBlockPos.m_123342_(), readBlockPos.m_123343_());
    }

    public Vec3 getLocation() {
        return new Vec3((double)this.m_123341_() / 2.0, (double)this.m_123342_() / 2.0 + (double)this.yOffsetPixels / 16.0, (double)this.m_123343_() / 2.0);
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object pOther) {
        if (!this.equalsIgnoreDim(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (!Objects.equals(tnl.dimension, this.dimension)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equalsIgnoreDim(Object pOther) {
        if (!super.equals(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (tnl.yOffsetPixels != this.yOffsetPixels) return false;
        return true;
    }

    public int hashCode() {
        return (this.m_123342_() + ((this.m_123343_() + this.yOffsetPixels * 31) * 31 + this.dimension.hashCode()) * 31) * 31 + this.m_123341_();
    }

    public CompoundTag write(DimensionPalette dimensions) {
        CompoundTag c = NbtUtils.m_129224_((BlockPos)new BlockPos((Vec3i)this));
        if (dimensions != null) {
            c.m_128405_("D", dimensions.encode(this.dimension));
        }
        if (this.yOffsetPixels != 0) {
            c.m_128405_("YO", this.yOffsetPixels);
        }
        return c;
    }

    public static TrackNodeLocation read(CompoundTag tag, DimensionPalette dimensions) {
        TrackNodeLocation location = TrackNodeLocation.fromPackedPos(NbtUtils.m_129239_((CompoundTag)tag));
        if (dimensions != null) {
            location.dimension = dimensions.decode(tag.m_128451_("D"));
        }
        location.yOffsetPixels = tag.m_128451_("YO");
        return location;
    }

    public void send(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        buffer.m_130130_(this.m_123341_());
        buffer.writeShort(this.m_123342_());
        buffer.m_130130_(this.m_123343_());
        buffer.m_130130_(this.yOffsetPixels);
        buffer.m_130130_(dimensions.encode(this.dimension));
    }

    public static TrackNodeLocation receive(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        TrackNodeLocation location = TrackNodeLocation.fromPackedPos(new BlockPos(buffer.m_130242_(), (int)buffer.readShort(), buffer.m_130242_()));
        location.yOffsetPixels = buffer.m_130242_();
        location.dimension = dimensions.decode(buffer.m_130242_());
        return location;
    }

    public Collection<BlockPos> allAdjacent() {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        Vec3 vec3 = this.getLocation().m_82492_(0.0, (double)this.yOffsetPixels / 16.0, 0.0);
        double step = 0.125;
        for (int x : Iterate.positiveAndNegative) {
            for (int y : Iterate.positiveAndNegative) {
                for (int z : Iterate.positiveAndNegative) {
                    set.add(BlockPos.m_274446_((Position)vec3.m_82520_((double)x * step, (double)y * step, (double)z * step)));
                }
            }
        }
        return set;
    }

    public static class DiscoveredLocation
    extends TrackNodeLocation {
        BezierConnection turn = null;
        boolean forceNode = false;
        Vec3 direction;
        Vec3 normal;
        TrackMaterial materialA;
        TrackMaterial materialB;

        public DiscoveredLocation(Level level, double x, double y, double z) {
            super(x, y, z);
            this.in(level);
        }

        public DiscoveredLocation(ResourceKey<Level> dimension, Vec3 vec) {
            super(vec);
            this.in(dimension);
        }

        public DiscoveredLocation(Level level, Vec3 vec) {
            this((ResourceKey<Level>)level.m_46472_(), vec);
        }

        public DiscoveredLocation materialA(TrackMaterial material) {
            this.materialA = material;
            return this;
        }

        public DiscoveredLocation materialB(TrackMaterial material) {
            this.materialB = material;
            return this;
        }

        public DiscoveredLocation materials(TrackMaterial materialA, TrackMaterial materialB) {
            this.materialA = materialA;
            this.materialB = materialB;
            return this;
        }

        public DiscoveredLocation viaTurn(BezierConnection turn) {
            this.turn = turn;
            if (turn != null) {
                this.forceNode();
            }
            return this;
        }

        public DiscoveredLocation forceNode() {
            this.forceNode = true;
            return this;
        }

        public DiscoveredLocation withNormal(Vec3 normal) {
            this.normal = normal;
            return this;
        }

        public DiscoveredLocation withYOffset(int yOffsetPixels) {
            this.yOffsetPixels = yOffsetPixels;
            return this;
        }

        public DiscoveredLocation withDirection(Vec3 direction) {
            this.direction = direction == null ? null : direction.m_82541_();
            return this;
        }

        public boolean connectedViaTurn() {
            return this.turn != null;
        }

        public BezierConnection getTurn() {
            return this.turn;
        }

        public boolean shouldForceNode() {
            return this.forceNode;
        }

        public boolean differentMaterials() {
            return this.materialA != this.materialB;
        }

        public boolean notInLineWith(Vec3 direction) {
            return this.direction != null && Math.max(direction.m_82526_(this.direction), direction.m_82526_(this.direction.m_82490_(-1.0))) < 0.875;
        }

        public Vec3 getDirection() {
            return this.direction;
        }
    }
}

