/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.searchtree;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.searchtree.RefreshableSearchTree;
import net.minecraft.client.searchtree.SearchRegistry;
import org.embeddedt.modernfix.ModernFix;

public class LazySearchTree<T>
implements RefreshableSearchTree<T> {
    private final List<T> contents;
    private final Function<List<T>, RefreshableSearchTree<T>> treeBuilder;
    private volatile RefreshableSearchTree<T> realTree;

    public LazySearchTree(List<T> contents, Function<List<T>, RefreshableSearchTree<T>> treeBuilder) {
        this.contents = contents;
        this.treeBuilder = treeBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefreshableSearchTree<T> getRealTree() {
        RefreshableSearchTree<T> t = this.realTree;
        if (t == null) {
            LazySearchTree lazySearchTree = this;
            synchronized (lazySearchTree) {
                t = this.realTree;
                if (t == null) {
                    ModernFix.LOGGER.info("Building search tree for {} items (this may take a while)...", (Object)this.contents.size());
                    Stopwatch s = Stopwatch.createStarted();
                    t = this.treeBuilder.apply(this.contents);
                    t.m_214078_();
                    s.stop();
                    ModernFix.LOGGER.info("Building search tree for {} items took {}", (Object)this.contents.size(), (Object)s);
                    this.realTree = t;
                }
            }
        }
        return t;
    }

    public List<T> m_6293_(String query) {
        if (query.isEmpty()) {
            return this.contents;
        }
        return this.getRealTree().m_6293_(query);
    }

    public void m_214078_() {
        RefreshableSearchTree<T> t = this.realTree;
        if (t != null) {
            t.m_214078_();
        }
    }

    public static <T> SearchRegistry.TreeBuilderSupplier<T> decorate(SearchRegistry.TreeBuilderSupplier<T> originalSupplier) {
        return list -> new LazySearchTree(list, originalSupplier);
    }
}

