/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.ForgeComputerCraftAPI;
import dan200.computercraft.api.detail.ForgeDetailRegistries;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.impl.MediaProviders;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.details.FluidData;
import dan200.computercraft.shared.integration.CreateIntegration;
import dan200.computercraft.shared.integration.MoreRedIntegration;
import dan200.computercraft.shared.peripheral.generic.methods.EnergyMethods;
import dan200.computercraft.shared.peripheral.generic.methods.FluidMethods;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.platform.ForgeConfigFile;
import dan200.computercraft.shared.platform.NetworkHandler;
import java.nio.file.Path;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;

@Mod(value="computercraft")
@Mod.EventBusSubscriber(modid="computercraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ComputerCraft {
    public ComputerCraft() {
        ModRegistry.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)((ForgeConfigFile)ConfigSpec.serverSpec).spec());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)((ForgeConfigFile)ConfigSpec.clientSpec).spec());
        NetworkHandler.setup();
    }

    @SubscribeEvent
    public static void registerRegistries(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(TurtleUpgradeSerialiser.registryId().m_135782_()).disableSaving().disableSync());
        event.create(new RegistryBuilder().setName(PocketUpgradeSerialiser.registryId().m_135782_()).disableSaving().disableSync());
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(WiredElement.class);
        event.register(IPeripheral.class);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(ModRegistry::registerMainThread);
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
        ComputerCraftAPI.registerGenericSource(new FluidMethods());
        ComputerCraftAPI.registerGenericSource(new EnergyMethods());
        ForgeComputerCraftAPI.registerGenericCapability(ForgeCapabilities.ITEM_HANDLER);
        ForgeComputerCraftAPI.registerGenericCapability(ForgeCapabilities.ENERGY);
        ForgeComputerCraftAPI.registerGenericCapability(ForgeCapabilities.FLUID_HANDLER);
        ForgeDetailRegistries.FLUID_STACK.addProvider(FluidData::fill);
        MediaProviders.registerDefault();
        if (ModList.get().isLoaded("create")) {
            event.enqueueWork(CreateIntegration::setup);
        }
        if (ModList.get().isLoaded("morered")) {
            MoreRedIntegration.setup();
        }
    }

    @SubscribeEvent
    public static void sync(ModConfigEvent.Loading event) {
        ComputerCraft.syncConfig(event.getConfig());
    }

    @SubscribeEvent
    public static void sync(ModConfigEvent.Reloading event) {
        ComputerCraft.syncConfig(event.getConfig());
    }

    private static void syncConfig(ModConfig config) {
        Path path;
        if (!config.getModId().equals("computercraft")) {
            return;
        }
        CommentedConfig commentedConfig = config.getConfigData();
        if (commentedConfig instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)commentedConfig;
            v0 = fileConfig.getNioPath();
        } else {
            v0 = path = null;
        }
        if (config.getType() == ModConfig.Type.SERVER && ((ForgeConfigFile)ConfigSpec.serverSpec).spec().isLoaded()) {
            ConfigSpec.syncServer(path);
        } else if (config.getType() == ModConfig.Type.CLIENT) {
            ConfigSpec.syncClient(path);
        }
    }

    @SubscribeEvent
    public static void onCreativeTab(BuildCreativeModeTabContentsEvent event) {
        CommonHooks.onBuildCreativeTab((ResourceKey<CreativeModeTab>)event.getTabKey(), event.getParameters(), (CreativeModeTab.Output)event);
    }
}

