/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.render.ComputerBorderRenderer;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.SpriteRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.util.ARGB32;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public final class PocketItemRenderer
extends ItemMapLikeRenderer {
    public static final PocketItemRenderer INSTANCE = new PocketItemRenderer();

    private PocketItemRenderer() {
    }

    @Override
    protected void renderItem(PoseStack transform, MultiBufferSource bufferSource, ItemStack stack, int light) {
        int termHeight;
        int termWidth;
        NetworkedTerminal terminal;
        PocketComputerData computer = ClientPocketComputers.get(stack);
        NetworkedTerminal networkedTerminal = terminal = computer == null ? null : computer.getTerminal();
        if (terminal == null) {
            termWidth = 26;
            termHeight = 20;
        } else {
            termWidth = terminal.getWidth();
            termHeight = terminal.getHeight();
        }
        int width = termWidth * 6 + 4;
        int height = termHeight * 9 + 4;
        transform.m_85836_();
        transform.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        transform.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        transform.m_85841_(0.5f, 0.5f, 0.5f);
        float scale = 0.75f / (float)Math.max(width + 24, height + 24 + 8);
        transform.m_85841_(scale, scale, -1.0f);
        transform.m_85837_(-0.5 * (double)width, -0.5 * (double)height, 0.0);
        PocketComputerItem item = (PocketComputerItem)stack.m_41720_();
        ComputerFamily family = item.getFamily();
        int frameColour = item.getColour(stack);
        Matrix4f matrix = transform.m_85850_().m_252922_();
        PocketItemRenderer.renderFrame(matrix, bufferSource, family, frameColour, light, width, height);
        int lightColour = computer == null || computer.getLightState() == -1 ? Colour.BLACK.getHex() : computer.getLightState();
        PocketItemRenderer.renderLight(transform, bufferSource, lightColour, width, height);
        FixedWidthFontRenderer.QuadEmitter quadEmitter = FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.m_6299_(RenderTypes.TERMINAL));
        if (terminal == null) {
            FixedWidthFontRenderer.drawEmptyTerminal(quadEmitter, 0.0f, 0.0f, width, height);
        } else {
            FixedWidthFontRenderer.drawTerminal(quadEmitter, 2.0f, 2.0f, terminal, 2.0f, 2.0f, 2.0f, 2.0f);
        }
        transform.m_85849_();
    }

    private static void renderFrame(Matrix4f transform, MultiBufferSource render, ComputerFamily family, int colour, int light, int width, int height) {
        GuiSprites.ComputerTextures texture = colour != -1 ? GuiSprites.COMPUTER_COLOUR : GuiSprites.getComputerTextures(family);
        int r = colour >>> 16 & 0xFF;
        int g = colour >>> 8 & 0xFF;
        int b = colour & 0xFF;
        SpriteRenderer spriteRenderer = new SpriteRenderer(transform, render.m_6299_(RenderTypes.GUI_SPRITES), 0, light, r, g, b);
        ComputerBorderRenderer.render(spriteRenderer, texture, 0, 0, width, height, true);
    }

    private static void renderLight(PoseStack transform, MultiBufferSource render, int colour, int width, int height) {
        VertexConsumer buffer = render.m_6299_(RenderTypes.TERMINAL);
        FixedWidthFontRenderer.drawQuad(FixedWidthFontRenderer.toVertexConsumer(transform, buffer), (float)(width - 16), (float)height + 6.0f, 0.001f, 16.0f, 8.0f, ARGB32.opaque(colour), 0xF000F0);
    }
}

