/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComputerAccess
implements IComputerAccess {
    private static final Logger LOG = LoggerFactory.getLogger(ComputerAccess.class);
    private final IAPIEnvironment environment;
    private final Set<String> mounts = new HashSet<String>(0);

    protected ComputerAccess(IAPIEnvironment environment) {
        this.environment = environment;
    }

    public void unmountAll() {
        FileSystem fileSystem = this.environment.getFileSystem();
        if (!this.mounts.isEmpty()) {
            LOG.warn("Peripheral or API called mount but did not call unmount for {}", this.mounts);
        }
        for (String mount : this.mounts) {
            fileSystem.unmount(mount);
        }
        this.mounts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized @Nullable String mount(String desiredLoc, Mount mount, String driveName) {
        String location;
        FileSystem fileSystem;
        Objects.requireNonNull(desiredLoc, "desiredLocation cannot be null");
        Objects.requireNonNull(mount, "mount cannot be null");
        Objects.requireNonNull(driveName, "driveName cannot be null");
        FileSystem fileSystem2 = fileSystem = this.environment.getFileSystem();
        synchronized (fileSystem2) {
            location = this.findFreeLocation(desiredLoc);
            if (location != null) {
                try {
                    fileSystem.mount(driveName, location, mount);
                }
                catch (FileSystemException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        }
        if (location != null) {
            this.mounts.add(location);
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized @Nullable String mountWritable(String desiredLoc, WritableMount mount, String driveName) {
        String location;
        FileSystem fileSystem;
        Objects.requireNonNull(desiredLoc, "desiredLocation cannot be null");
        Objects.requireNonNull(mount, "mount cannot be null");
        Objects.requireNonNull(driveName, "driveName cannot be null");
        FileSystem fileSystem2 = fileSystem = this.environment.getFileSystem();
        synchronized (fileSystem2) {
            location = this.findFreeLocation(desiredLoc);
            if (location != null) {
                try {
                    fileSystem.mountWritable(driveName, location, mount);
                }
                catch (FileSystemException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        }
        if (location != null) {
            this.mounts.add(location);
        }
        return location;
    }

    @Override
    public void unmount(@Nullable String location) {
        if (location == null) {
            return;
        }
        if (!this.mounts.contains(location)) {
            throw new IllegalStateException("You didn't mount this location");
        }
        this.environment.getFileSystem().unmount(location);
        this.mounts.remove(location);
    }

    @Override
    public int getID() {
        return this.environment.getComputerID();
    }

    @Override
    public void queueEvent(String event, Object ... arguments) {
        Objects.requireNonNull(event, "event cannot be null");
        this.environment.queueEvent(event, arguments);
    }

    @Override
    public WorkMonitor getMainThreadMonitor() {
        return this.environment.getMainThreadMonitor();
    }

    private @Nullable String findFreeLocation(String desiredLoc) {
        try {
            FileSystem fileSystem = this.environment.getFileSystem();
            if (!fileSystem.exists(desiredLoc)) {
                return desiredLoc;
            }
            return null;
        }
        catch (FileSystemException e) {
            return null;
        }
    }
}

