/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.util.SidedCapabilityProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MoreRedIntegration {
    public static final String MOD_ID = "morered";
    private static final ResourceLocation ID = new ResourceLocation("computercraft", "morered");

    @SubscribeEvent
    public static void attachBlockCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity blockEntity = (BlockEntity)event.getObject();
        Block block = blockEntity.m_58900_().m_60734_();
        if (block instanceof IBundledRedstoneBlock) {
            IBundledRedstoneBlock bundledBlock = (IBundledRedstoneBlock)block;
            SidedCapabilityProvider.attach(event, ID, MoreRedAPI.CHANNELED_POWER_CAPABILITY, side -> (world, wirePos, wireState, wireFace, channel) -> {
                if (side == null) {
                    return 0;
                }
                int level = bundledBlock.getBundledRedstoneOutput(world, blockEntity.m_58899_(), side);
                return (level & 1 << channel) != 0 ? 31 : 0;
            });
        }
    }

    public static void setup() {
        MinecraftForge.EVENT_BUS.register(MoreRedIntegration.class);
        ComputerCraftAPI.registerBundledRedstoneProvider(MoreRedIntegration::getBundledPower);
    }

    private static int getBundledPower(Level world, BlockPos pos, Direction side) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity == null) {
            return -1;
        }
        BlockState blockState = blockEntity.m_58900_();
        if (blockState.m_60734_() instanceof IBundledRedstoneBlock) {
            return -1;
        }
        LazyOptional powerCap = blockEntity.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, side);
        if (!powerCap.isPresent()) {
            return -1;
        }
        ChanneledPowerSupplier power = (ChanneledPowerSupplier)powerCap.orElseThrow(NullPointerException::new);
        int mask = 0;
        for (int i = 0; i < 16; ++i) {
            mask |= power.getPowerOnChannel(world, pos, blockState, side, i) > 0 ? 1 << i : 0;
        }
        return mask;
    }
}

