/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.lectern;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.container.BasicContainer;
import dan200.computercraft.shared.container.SingleContainerData;
import dan200.computercraft.shared.media.PrintoutMenu;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public final class CustomLecternBlockEntity
extends BlockEntity {
    private static final String NBT_ITEM = "Item";
    private static final String NBT_PAGE = "Page";
    private ItemStack item = ItemStack.f_41583_;
    private int page;
    private int pageCount;

    public CustomLecternBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.BlockEntities.LECTERN.get(), pos, blockState);
    }

    public ItemStack getItem() {
        return this.item;
    }

    void setItem(ItemStack item) {
        this.item = item;
        this.itemChanged();
        BlockEntityHelpers.updateBlock(this);
    }

    int getRedstoneSignal() {
        if (this.item.m_41720_() instanceof PrintoutItem) {
            float progress = this.pageCount > 1 ? (float)this.page / (float)(this.pageCount - 1) : 1.0f;
            return Mth.m_14143_((float)(progress * 14.0f)) + 1;
        }
        return 15;
    }

    private void itemChanged() {
        if (this.item.m_41720_() instanceof PrintoutItem) {
            this.pageCount = PrintoutItem.getPageCount(this.item);
            this.page = Mth.m_14045_((int)this.page, (int)0, (int)(this.pageCount - 1));
        } else {
            this.page = 0;
            this.pageCount = 0;
        }
    }

    void tick() {
        Item item = this.item.m_41720_();
        if (item instanceof PocketComputerItem) {
            PocketComputerItem pocket = (PocketComputerItem)item;
            pocket.tick(this.item, new PocketHolder.LecternHolder(this), false);
        }
    }

    private void setPage(int page) {
        if (this.page == page) {
            return;
        }
        this.page = page;
        this.m_6596_();
        if (this.m_58904_() != null) {
            LecternBlock.m_54488_((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.item = tag.m_128425_(NBT_ITEM, 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(NBT_ITEM)) : ItemStack.f_41583_;
        this.page = tag.m_128451_(NBT_PAGE);
        this.itemChanged();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.item.m_41619_()) {
            tag.m_128365_(NBT_ITEM, (Tag)this.item.m_41739_(new CompoundTag()));
        }
        if (this.item.m_41720_() instanceof PrintoutItem) {
            tag.m_128405_(NBT_PAGE, this.page);
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (!this.item.m_41619_()) {
            tag.m_128365_(NBT_ITEM, (Tag)this.item.m_41739_(new CompoundTag()));
        }
        return tag;
    }

    void openMenu(Player player) {
        ItemStack item = this.getItem();
        if (item.m_41720_() instanceof PrintoutItem) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, entity) -> new PrintoutMenu(id, new LecternContainer(), 0, p -> Container.m_271806_((BlockEntity)this, (Player)p, (int)8), new PrintoutContainerData()), this.getItem().m_41611_()));
        } else {
            Item item2 = item.m_41720_();
            if (item2 instanceof PocketComputerItem) {
                PocketComputerItem pocket = (PocketComputerItem)item2;
                pocket.open(player, item, new PocketHolder.LecternHolder(this), true);
            }
        }
    }

    private final class LecternContainer
    implements BasicContainer {
        private final List<ItemStack> itemView = new AbstractList<ItemStack>(){

            @Override
            public ItemStack get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("Inventory only has one slot");
                }
                return CustomLecternBlockEntity.this.item;
            }

            @Override
            public int size() {
                return 1;
            }
        };

        private LecternContainer() {
        }

        @Override
        public List<ItemStack> getContents() {
            return this.itemView;
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return !CustomLecternBlockEntity.this.m_58901_();
        }
    }

    private final class PrintoutContainerData
    implements SingleContainerData {
        private PrintoutContainerData() {
        }

        @Override
        public int get() {
            return CustomLecternBlockEntity.this.page;
        }

        @Override
        public void m_8050_(int index, int value) {
            if (index == 0) {
                CustomLecternBlockEntity.this.setPage(value);
            }
        }
    }
}

