/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import net.minecraft.core.Direction;

public record XYPair(float x, float y) {
    public XYPair add(float x, float y) {
        return new XYPair(this.x + x, this.y + y);
    }

    public static XYPair of(float xPos, float yPos, float zPos, Direction facing, Direction orientation) {
        return switch (orientation) {
            case Direction.NORTH -> {
                switch (facing) {
                    case NORTH: {
                        yield new XYPair(1.0f - xPos, 1.0f - yPos);
                    }
                    case SOUTH: {
                        yield new XYPair(xPos, 1.0f - yPos);
                    }
                    case WEST: {
                        yield new XYPair(zPos, 1.0f - yPos);
                    }
                    case EAST: {
                        yield new XYPair(1.0f - zPos, 1.0f - yPos);
                    }
                }
                throw new IllegalStateException("Invalid facing " + String.valueOf(facing));
            }
            case Direction.DOWN -> {
                switch (facing) {
                    case NORTH: {
                        yield new XYPair(1.0f - xPos, zPos);
                    }
                    case SOUTH: {
                        yield new XYPair(xPos, 1.0f - zPos);
                    }
                    case WEST: {
                        yield new XYPair(zPos, xPos);
                    }
                    case EAST: {
                        yield new XYPair(1.0f - zPos, 1.0f - xPos);
                    }
                }
                throw new IllegalStateException("Invalid facing " + String.valueOf(facing));
            }
            case Direction.UP -> {
                switch (facing) {
                    case NORTH: {
                        yield new XYPair(1.0f - xPos, 1.0f - zPos);
                    }
                    case SOUTH: {
                        yield new XYPair(xPos, zPos);
                    }
                    case WEST: {
                        yield new XYPair(zPos, 1.0f - xPos);
                    }
                    case EAST: {
                        yield new XYPair(1.0f - zPos, xPos);
                    }
                }
                throw new IllegalStateException("Invalid facing " + String.valueOf(facing));
            }
            default -> new XYPair(xPos, zPos);
        };
    }
}

