/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.impl.Services;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkHandler.class);
    private static final SimpleChannel network;

    private NetworkHandler() {
    }

    public static void setup() {
        MessageTypeImpl forgeType;
        for (MessageType<? extends NetworkMessage<ServerNetworkContext>> messageType : NetworkMessages.getServerbound()) {
            forgeType = (MessageTypeImpl)messageType;
            NetworkHandler.registerMainThread(forgeType, NetworkDirection.PLAY_TO_SERVER, c -> () -> Nullability.assertNonNull(c.getSender()));
        }
        for (MessageType<NetworkMessage<Object>> messageType : NetworkMessages.getClientbound()) {
            forgeType = (MessageTypeImpl)messageType;
            NetworkHandler.registerMainThread(forgeType, NetworkDirection.PLAY_TO_CLIENT, x -> ClientHolder.get());
        }
    }

    public static Packet<ClientGamePacketListener> createClientboundPacket(NetworkMessage<ClientNetworkContext> packet) {
        return network.toVanillaPacket(packet, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static Packet<ServerGamePacketListener> createServerboundPacket(NetworkMessage<ServerNetworkContext> packet) {
        return network.toVanillaPacket(packet, NetworkDirection.PLAY_TO_SERVER);
    }

    static <H, T extends NetworkMessage<H>> void registerMainThread(MessageTypeImpl<T> type, NetworkDirection direction, Function<NetworkEvent.Context, H> handler) {
        network.messageBuilder(type.klass(), type.id(), direction).encoder(NetworkMessage::write).decoder(type.reader()).consumerMainThread((packet, contextSup) -> {
            try {
                packet.handle(handler.apply((NetworkEvent.Context)contextSup.get()));
            }
            catch (Error | RuntimeException e) {
                LOG.error("Failed handling packet", e);
                throw e;
            }
        }).add();
    }

    static {
        String version = ComputerCraftAPI.getInstalledVersion();
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("computercraft", "network")).networkProtocolVersion(() -> version).clientAcceptedVersions(version::equals).serverAcceptedVersions(version::equals).simpleChannel();
    }

    public record MessageTypeImpl<T extends NetworkMessage<?>>(int id, Class<T> klass, Function<FriendlyByteBuf, T> reader) implements MessageType<T>
    {
    }

    private static final class ClientHolder {
        private static final @Nullable ClientNetworkContext INSTANCE;
        private static final @Nullable Throwable ERROR;

        private ClientHolder() {
        }

        static ClientNetworkContext get() {
            ClientNetworkContext instance = INSTANCE;
            return instance == null ? Services.raise(ClientNetworkContext.class, ERROR) : instance;
        }

        static {
            Services.LoadedService<ClientNetworkContext> helper = Services.tryLoad(ClientNetworkContext.class);
            INSTANCE = helper.instance();
            ERROR = helper.error();
        }
    }
}

