/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.champions.api.ChampionsApiImpl;
import top.theillusivec4.champions.api.IChampionsApi;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.event.ModEventHandler;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.GatewaysToEternityCompat;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;
import top.theillusivec4.champions.common.util.Utils;

@Mod(value="champions")
public class Champions {
    public static final String MODID = "champions";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final IChampionsApi API = ChampionsApiImpl.getInstance();
    private static Champions INSTANCE;
    public final ModLoadingContext modContext;

    public Champions() {
        INSTANCE = this;
        this.modContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.modContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientChampionsConfig.CLIENT_SPEC);
        this.modContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ChampionsConfig.SERVER_SPEC);
        this.modContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ChampionsConfig.COMMON_SPEC);
        Utils.createServerConfig(ChampionsConfig.RANKS_SPEC, "ranks");
        Utils.createServerConfig(ChampionsConfig.ENTITIES_SPEC, "entities");
        modEventBus.register((Object)new ModEventHandler());
        if (Utils.isGameStagesLoaded()) {
            this.modContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ChampionsConfig.STAGE_SPEC, "champions-gamestages.toml");
        }
        if (Utils.isGatewaysLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new GatewaysToEternityCompat());
        }
        ChampionsRegistry.register(modEventBus);
    }

    public static Champions getInstance() {
        return INSTANCE;
    }
}

