/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IAffixBuilder;
import top.theillusivec4.champions.api.data.AffixCategory;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.api.data.IntCodec;
import top.theillusivec4.champions.common.config.ConfigEnums;

public class BasicAffixBuilder<T extends IAffix>
implements IAffixBuilder<T> {
    private Supplier<T> affixSupplier;
    private ResourceLocation type;
    private boolean isEnable;
    private MinMaxBounds.Ints tier;
    private List<ResourceLocation> mobList;
    private ConfigEnums.Permission mobPermission;
    private AffixCategory category;
    private String prefix;
    private boolean hasSubscriptions;

    public BasicAffixBuilder(Supplier<T> affixSupplier) {
        this.affixSupplier = affixSupplier;
    }

    public void setAffixSupplier(Supplier<T> affixSupplier) {
        this.affixSupplier = affixSupplier;
    }

    public static <T extends IAffix, B extends BasicAffixBuilder<T>> Codec<T> of(Supplier<B> builderSupplier) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("setEnable").forGetter(IAffix::isEnabled), (App)IntCodec.codec().fieldOf("tier").forGetter(IAffix::getTier), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("mobList").forGetter(IAffix::getMobList), (App)StringRepresentable.m_216439_(ConfigEnums.Permission::values).fieldOf("mobPermission").forGetter(IAffix::getMobPermission), (App)StringRepresentable.m_216439_(AffixCategory::values).fieldOf("category").forGetter(IAffix::getCategory), (App)Codec.STRING.fieldOf("prefix").forGetter(IAffix::getPrefix), (App)Codec.BOOL.fieldOf("hasSubscriptions").forGetter(IAffix::hasSubscriptions)).apply((Applicative)instance, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> BasicAffixBuilder.lambda$of$0((Supplier)builderSupplier, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6)));
    }

    @Override
    public BasicAffixBuilder<T> setType(ResourceLocation type) {
        this.type = type;
        return this;
    }

    @Override
    public BasicAffixBuilder<T> setCategory(AffixCategory pCategory) {
        this.category = pCategory;
        return this;
    }

    @Override
    public BasicAffixBuilder<T> setPrefix(String pPrefix) {
        this.prefix = pPrefix;
        return this;
    }

    @Override
    public IAffixBuilder<T> setHasSub() {
        this.hasSubscriptions = true;
        return this;
    }

    public IAffixBuilder<T> setHasSub(boolean pHasSub) {
        this.hasSubscriptions = pHasSub;
        return this;
    }

    @Override
    public IAffixBuilder<T> setEnable(boolean pEnable) {
        this.isEnable = pEnable;
        return this;
    }

    @Override
    public IAffixBuilder<T> setMobList(List<ResourceLocation> mobList) {
        this.mobList = mobList;
        return this;
    }

    @Override
    public IAffixBuilder<T> setTier(MinMaxBounds.Ints tier) {
        this.tier = tier;
        return this;
    }

    @Override
    public IAffixBuilder<T> setMobPermission(ConfigEnums.Permission mobPermission) {
        this.mobPermission = mobPermission;
        return this;
    }

    @Override
    public T build() {
        IAffix affix = (IAffix)this.affixSupplier.get();
        this.apply(affix);
        return (T)affix;
    }

    private void apply(T pAffix) {
        pAffix.applySetting(new AffixSetting(this.type, this.isEnable, Optional.ofNullable(this.tier), Optional.ofNullable(this.mobList), Optional.ofNullable(this.mobPermission), this.category, Optional.ofNullable(this.prefix), Optional.of(this.hasSubscriptions)));
        Champions.API.addCategory(this.category, (IAffix)pAffix);
    }

    private static /* synthetic */ IAffix lambda$of$0(Supplier builderSupplier, Boolean isEnable, MinMaxBounds.Ints tier, Optional mobList, ConfigEnums.Permission permission, AffixCategory category, String prefix, Boolean hasSubscriptions) {
        BasicAffixBuilder builder = (BasicAffixBuilder)builderSupplier.get();
        builder.setEnable(isEnable).setTier(tier).setMobList(mobList.orElse(List.of())).setMobPermission(permission).setCategory(category).setPrefix(prefix);
        if (hasSubscriptions.booleanValue()) {
            builder.setHasSub();
        }
        return builder.build();
    }
}

