/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.api;

import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.AffixCategory;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.config.ConfigEnums;

public interface IAffix {
    public ResourceLocation getIdentifier();

    public AffixCategory getCategory();

    default public boolean sameCategory(AffixCategory other) {
        return other == this.getCategory();
    }

    default public String toLanguageKey() {
        return this.getPrefix() + this.getIdentifier().m_214298_();
    }

    public String getPrefix();

    public boolean hasSubscriptions();

    public boolean isEnabled();

    public MinMaxBounds.Ints getTier();

    default public void onInitialSpawn(IChampion champion) {
    }

    default public void onSpawn(IChampion champion) {
    }

    default public void onServerUpdate(IChampion champion) {
    }

    default public void onClientUpdate(IChampion champion) {
    }

    default public boolean onAttack(IChampion champion, LivingEntity target, DamageSource source, float amount) {
        return true;
    }

    default public boolean onAttacked(IChampion champion, DamageSource source, float amount) {
        return true;
    }

    default public float onHurt(IChampion champion, DamageSource source, float amount, float newAmount) {
        return newAmount;
    }

    default public float onHeal(IChampion champion, float amount, float newAmount) {
        return newAmount;
    }

    default public float onDamage(IChampion champion, DamageSource source, float amount, float newAmount) {
        return newAmount;
    }

    default public boolean onDeath(IChampion champion, DamageSource source) {
        return true;
    }

    default public boolean canApply(IChampion champion) {
        return true;
    }

    default public boolean isCompatible(IAffix affix) {
        return affix != this;
    }

    public void sync(IChampion var1);

    default public void readSyncTag(IChampion champion, CompoundTag tag) {
    }

    default public CompoundTag writeSyncTag(IChampion champion) {
        return new CompoundTag();
    }

    public ConfigEnums.Permission getMobPermission();

    public Optional<List<ResourceLocation>> getMobList();

    public void applySetting(AffixSetting var1);

    public AffixSetting getSetting();
}

