/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.datagen;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.api.data.AttributesModifierDataLoader;
import top.theillusivec4.champions.api.data.ChampionModifierCondition;
import top.theillusivec4.champions.api.data.ModifierSetting;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.loot.AffixesPredicate;

public class AttributesModifierDataProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;

    public AttributesModifierDataProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.packOutput = packOutput;
        this.lookupProvider = lookupProvider;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        ArrayList futures = new ArrayList();
        try {
            this.lookupProvider.get().m_255025_(Registries.f_256728_).m_214062_().forEach(attribute -> {
                ResourceLocation attributeId = attribute.m_205785_().m_135782_();
                var ref = new Object(){
                    double baseValue = 1.0;
                    boolean enable = false;
                    AttributeModifier.Operation operation = AttributeModifier.Operation.ADDITION;
                };
                Path outputPath = this.packOutput.m_245114_().resolve("data").resolve(attributeId.m_135827_()).resolve(AttributesModifierDataLoader.getFolder()).resolve(attributeId.m_135815_() + ".json");
                if (attributeId == ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22276_)) {
                    ref.baseValue = 0.35;
                    ref.enable = true;
                    ref.operation = AttributeModifier.Operation.MULTIPLY_TOTAL;
                } else if (attributeId == ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22281_)) {
                    ref.baseValue = 0.5;
                    ref.enable = true;
                    ref.operation = AttributeModifier.Operation.MULTIPLY_TOTAL;
                } else if (attributeId == ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22284_)) {
                    ref.baseValue = 2.0;
                    ref.enable = true;
                } else if (attributeId == ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22285_)) {
                    ref.baseValue = 1.0;
                    ref.enable = true;
                } else if (attributeId == ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22278_)) {
                    ref.baseValue = 0.05;
                    ref.enable = true;
                } else {
                    ref.baseValue = 0.0;
                    ref.enable = false;
                    ref.operation = AttributeModifier.Operation.ADDITION;
                }
                futures.add(this.lookupProvider.thenCompose(provider -> DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)((JsonElement)ModifierSetting.MAP_CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new ModifierSetting(attributeId, ref.enable, (Pair<Double, AttributeModifier.Operation>)Pair.of((Object)ref.baseValue, (Object)ref.operation), Optional.of(new ChampionModifierCondition(Optional.of(Set.of(new ResourceLocation("minecraft:creeper"))), Optional.of(MinMaxBounds.Ints.f_55364_), Optional.of(new AffixesPredicate(Set.of(), MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_)), ConfigEnums.Permission.BLACKLIST)))).result().orElseThrow()), (Path)outputPath)));
            });
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "attribute modifiers";
    }
}

