/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.event;

import com.electronwill.nightconfig.core.CommentedConfig;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.client.integration.theoneprobe.TheOneProbePlugin;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.datagen.AffixConfigProvider;
import top.theillusivec4.champions.common.datagen.AttributesModifierDataProvider;
import top.theillusivec4.champions.common.datagen.GatewaysConfigProvider;
import top.theillusivec4.champions.common.datagen.ModDamageTypeTagsProvider;
import top.theillusivec4.champions.common.datagen.ModDatapackProvider;
import top.theillusivec4.champions.common.datagen.ModEntityTypeTagsProvider;
import top.theillusivec4.champions.common.datagen.ModLanguageProvider;
import top.theillusivec4.champions.common.item.dispense.DispenseHandler;
import top.theillusivec4.champions.common.loot.EntityIsChampion;
import top.theillusivec4.champions.common.loot.LootItemChampionPropertyCondition;
import top.theillusivec4.champions.common.network.NetworkHandler;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.registry.ModItems;
import top.theillusivec4.champions.common.stat.ChampionsStats;
import top.theillusivec4.champions.common.util.EntityManager;
import top.theillusivec4.champions.common.util.Utils;
import top.theillusivec4.champions.server.command.ChampionSelectorOptions;

public class ModEventHandler {
    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent evt) {
        evt.enqueueWork(() -> {
            ChampionCapability.register();
            NetworkHandler.register();
            ChampionsStats.setup();
            ChampionSelectorOptions.setup();
            Registry.m_122965_((Registry)BuiltInRegistries.f_256991_, (ResourceLocation)Utils.getLocation("entity_champion"), (Object)EntityIsChampion.type);
            Registry.m_122965_((Registry)BuiltInRegistries.f_256991_, (ResourceLocation)Utils.getLocation("champion_properties"), (Object)LootItemChampionPropertyCondition.INSTANCE);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.CHAMPION_EGG_ITEM.get()), DispenseHandler::handleChampionEggDispense);
        });
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.register(IChampion.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void config(ModConfigEvent.Loading evt) {
        if (!evt.getConfig().getModId().equals("champions")) {
            return;
        }
        if (evt.getConfig().getType() == ModConfig.Type.SERVER) {
            ModEventHandler modEventHandler = this;
            synchronized (modEventHandler) {
                IConfigSpec spec = evt.getConfig().getSpec();
                CommentedConfig commentedConfig = evt.getConfig().getConfigData();
                ChampionsConfig.bake();
                try {
                    if (spec == ChampionsConfig.RANKS_SPEC) {
                        ChampionsConfig.transformRanks(commentedConfig);
                        RankManager.buildRanks();
                    } else if (spec == ChampionsConfig.ENTITIES_SPEC) {
                        ChampionsConfig.transformEntities(commentedConfig);
                        EntityManager.buildEntitySettings();
                    } else if (spec == ChampionsConfig.STAGE_SPEC && Utils.isGameStagesLoaded()) {
                        ChampionsConfig.entityStages = (List)ChampionsConfig.STAGE.entityStages.get();
                        ChampionsConfig.tierStages = (List)ChampionsConfig.STAGE.tierStages.get();
                    }
                }
                catch (Exception e) {
                    Champions.LOGGER.error("Error loading config, please remove this file or check the format is correct: {}", (Object)FMLPaths.GAMEDIR.get().resolve(evt.getConfig().getFullPath()), (Object)e);
                }
            }
        }
        if (evt.getConfig().getType() == ModConfig.Type.CLIENT) {
            ClientChampionsConfig.bake();
        } else if (evt.getConfig().getType() == ModConfig.Type.COMMON) {
            ChampionsConfig.bakeCommon();
        }
    }

    @SubscribeEvent
    public void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            Champions.LOGGER.info("Champions detected TheOneProbe, registering plugin now");
            InterModComms.sendTo((String)"champions", (String)"theoneprobe", (String)"getTheOneProbe", TheOneProbePlugin.GetTheOneProbe::new);
        }
    }

    @SubscribeEvent
    public void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ModDatapackProvider datapackProvider = (ModDatapackProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModDatapackProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new GatewaysConfigProvider(packOutput, datapackProvider.getRegistryProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeTagsProvider(packOutput, datapackProvider.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AffixConfigProvider(packOutput, datapackProvider.getRegistryProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new AttributesModifierDataProvider(packOutput, datapackProvider.getRegistryProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "zh_cn"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "ko_kr"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "ru_ru"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "tr_tr"));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(packOutput, "uk_ua"));
    }
}

