/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.util.ChampionBuilder;

public class ChampionEggItem
extends EggItem {
    private static final String ID_TAG = "Id";
    private static final String ENTITY_TAG = "EntityTag";
    private static final String TIER_TAG = "Tier";
    private static final String AFFIX_TAG = "Affix";
    private static final String CHAMPION_TAG = "Champion";

    public ChampionEggItem() {
        super(new Item.Properties());
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        SpawnEggItem eggItem = ForgeSpawnEggItem.fromEntityType((EntityType)ChampionEggItem.getType(stack).orElse(EntityType.f_20501_));
        return eggItem != null ? eggItem.m_43211_(tintIndex) : 0;
    }

    public static Optional<EntityType<?>> getType(ItemStack stack) {
        String id;
        Optional<CompoundTag> entityTag = ChampionEggItem.getTagOrEmpty(stack, ENTITY_TAG);
        if (entityTag.isPresent() && !(id = entityTag.get().m_128461_(ID_TAG)).isEmpty()) {
            return Optional.ofNullable((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(id)));
        }
        return Optional.empty();
    }

    public static void read(IChampion champion, ItemStack stack) {
        Optional<CompoundTag> tag = ChampionEggItem.getTagOrEmpty(stack, CHAMPION_TAG);
        tag.ifPresent(entityTag -> {
            int tier = entityTag.m_128451_(TIER_TAG);
            ListTag affixTag = entityTag.m_128437_(AFFIX_TAG, 8);
            ArrayList<IAffix> affixes = new ArrayList<IAffix>();
            affixTag.forEach(affix -> Champions.API.getAffix(affix.m_7916_()).ifPresent(affixes::add));
            ChampionBuilder.spawnPreset(champion, tier, affixes);
        });
    }

    public static void write(ItemStack stack, ResourceLocation entityId, int tier, Collection<IAffix> affixes) {
        CompoundTag tag;
        CompoundTag compoundTag = tag = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        assert (tag != null);
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128359_(ID_TAG, entityId.toString());
        tag.m_128365_(ENTITY_TAG, (Tag)compoundNBT);
        CompoundTag tierTag = new CompoundTag();
        tierTag.m_128405_(TIER_TAG, tier);
        ListTag listNBT = new ListTag();
        affixes.forEach(affix -> listNBT.add((Object)StringTag.m_129297_((String)affix.toString())));
        tierTag.m_128365_(AFFIX_TAG, (Tag)listNBT);
        tag.m_128365_(CHAMPION_TAG, (Tag)tierTag);
        stack.m_41751_(tag);
    }

    public static Optional<CompoundTag> getTagOrEmpty(ItemStack stack, String tagKey) {
        CompoundTag entityTag;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (entityTag = stack.m_41737_(tagKey)) != null) {
            return Optional.of(entityTag);
        }
        return Optional.empty();
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        int tier = 0;
        Optional<EntityType<?>> type = ChampionEggItem.getType(stack);
        Optional<CompoundTag> entityTag = ChampionEggItem.getTagOrEmpty(stack, CHAMPION_TAG);
        if (entityTag.isPresent()) {
            tier = entityTag.get().m_128451_(TIER_TAG);
        }
        MutableComponent root = Component.m_237115_((String)("rank.champions.title." + tier));
        root.m_130946_(" ");
        root.m_7220_(type.map(EntityType::m_20676_).orElse(EntityType.f_20501_.m_20676_()));
        root.m_130946_(" ");
        root.m_7220_(this.m_41466_());
        return root;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        boolean hasAffix = false;
        Optional<CompoundTag> entityTag = ChampionEggItem.getTagOrEmpty(stack, CHAMPION_TAG);
        if (entityTag.isPresent()) {
            ListTag affixTag = entityTag.get().m_128437_(AFFIX_TAG, 8);
            if (!affixTag.isEmpty()) {
                hasAffix = true;
            }
            affixTag.forEach(affix -> Champions.API.getAffix(affix.m_7916_()).ifPresent(affix1 -> {
                MutableComponent component = Component.m_237115_((String)affix1.toLanguageKey());
                component.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
                tooltip.add((Component)component);
            }));
        }
        if (!hasAffix) {
            MutableComponent component = Component.m_237115_((String)"item.champions.egg.tooltip");
            component.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA));
            tooltip.add((Component)component);
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!world.m_5776_() && world instanceof ServerLevel) {
            ItemStack itemstack = context.m_43722_();
            BlockPos blockpos = context.m_8083_();
            Direction direction = context.m_43719_();
            BlockState blockstate = world.m_8055_(blockpos);
            BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
            Optional<EntityType<?>> entitytype = ChampionEggItem.getType(itemstack);
            entitytype.ifPresent(type -> {
                Entity entity = type.m_262451_((ServerLevel)world, itemstack.m_41783_(), null, blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
                if (entity instanceof LivingEntity) {
                    ChampionCapability.getCapability(entity).ifPresent(champion -> ChampionEggItem.read(champion, itemstack));
                    world.m_7967_(entity);
                    itemstack.m_41774_(1);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (worldIn.m_5776_()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (worldIn instanceof ServerLevel) {
            BlockHitResult raytraceresult = ChampionEggItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
            BlockPos blockpos = raytraceresult.m_82425_();
            if (!(worldIn.m_6425_(blockpos).m_76152_() instanceof FlowingFluid)) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
            if (worldIn.m_7966_(playerIn, blockpos) && playerIn.m_36204_(blockpos, raytraceresult.m_82434_(), itemstack)) {
                Optional<EntityType<?>> entityType = ChampionEggItem.getType(itemstack);
                return entityType.map(type -> {
                    Entity entity = type.m_262451_((ServerLevel)worldIn, itemstack.m_41783_(), null, blockpos, MobSpawnType.SPAWN_EGG, false, false);
                    if (entity instanceof LivingEntity) {
                        ChampionCapability.getCapability(entity).ifPresent(champion -> ChampionEggItem.read(champion, itemstack));
                        worldIn.m_7967_(entity);
                        if (!playerIn.m_150110_().f_35934_) {
                            itemstack.m_41774_(1);
                        }
                        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
                    }
                    return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
                }).orElse(new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack));
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
    }
}

