/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.rank.Rank;

public class EntityIsChampion
implements LootItemCondition {
    public static LootItemConditionType type = new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    @Nullable
    private final Integer minTier;
    @Nullable
    private final Integer maxTier;
    private final LootContext.EntityTarget target;

    private EntityIsChampion(@Nullable Integer minTier, @Nullable Integer maxTier, LootContext.EntityTarget targetIn) {
        this.minTier = minTier;
        this.maxTier = maxTier;
        this.target = targetIn;
    }

    @NotNull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)this.target.m_79003_());
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.m_78953_(this.target.m_79003_());
        if (entity == null) {
            return false;
        }
        return ChampionCapability.getCapability(entity).map(champion -> {
            int tier = champion.getServer().getRank().map(Rank::getTier).orElse(0);
            boolean aboveMin = this.minTier == null ? tier >= 1 : tier >= this.minTier;
            boolean belowMax = this.maxTier == null || tier <= this.maxTier;
            return aboveMin && belowMax;
        }).orElse(false);
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return type;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<EntityIsChampion> {
        public void serialize(JsonObject json, EntityIsChampion value, JsonSerializationContext context) {
            json.addProperty("maxTier", (Number)value.maxTier);
            json.addProperty("minTier", (Number)value.minTier);
            json.add("entity", context.serialize((Object)value.target));
        }

        @Nonnull
        public EntityIsChampion deserialize(JsonObject json, @Nonnull JsonDeserializationContext context) {
            Integer minTier = json.has("minTier") ? Integer.valueOf(GsonHelper.m_13927_((JsonObject)json, (String)"minTier")) : null;
            Integer maxTier = json.has("maxTier") ? Integer.valueOf(GsonHelper.m_13927_((JsonObject)json, (String)"maxTier")) : null;
            return new EntityIsChampion(minTier, maxTier, (LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class));
        }
    }
}

