/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;

public class SPacketSyncChampion {
    private final int entityId;
    private final int tier;
    private final String defaultColor;
    private final Set<ResourceLocation> affixes;
    private final int affixSize;

    public SPacketSyncChampion(int entityId, int tier, String defaultColor, Set<ResourceLocation> affixes) {
        this.entityId = entityId;
        this.tier = tier;
        this.affixSize = affixes.size();
        this.affixes = affixes;
        this.defaultColor = defaultColor;
    }

    public static void encode(SPacketSyncChampion msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.tier);
        buf.writeInt(msg.affixSize);
        buf.m_130070_(msg.defaultColor);
        msg.affixes.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130085_(arg_0));
    }

    public static SPacketSyncChampion decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int tier = buf.readInt();
        HashSet<ResourceLocation> affixes = new HashSet<ResourceLocation>();
        int affixSize = buf.readInt();
        String defaultColor = buf.m_130277_();
        for (int i = 0; i < affixSize; ++i) {
            affixes.add(buf.m_130281_());
        }
        return new SPacketSyncChampion(entityId, tier, defaultColor, affixes);
    }

    public static void handle(SPacketSyncChampion msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null) {
                Entity entity = world.m_6815_(msg.entityId);
                ChampionCapability.getCapability(entity).ifPresent(champion -> {
                    IChampion.Client clientChampion = champion.getClient();
                    clientChampion.setRank((Tuple<Integer, String>)new Tuple((Object)msg.tier, (Object)msg.defaultColor));
                    clientChampion.setAffixes(msg.affixes);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

