/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.rank;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import top.theillusivec4.champions.api.IAffix;

public class Rank {
    private final int tier;
    private final String defaultColor;
    private final int numAffixes;
    private final int growthFactor;
    private final int weight;
    private final List<Tuple<Holder<MobEffect>, Integer>> effects;
    private final List<IAffix> presetAffixes;

    public Rank() {
        this(0, 0, 0, 0, "#FF000000", new ArrayList<Tuple<Holder<MobEffect>, Integer>>(), new ArrayList<IAffix>());
    }

    public Rank(int tier, int numAffixes, int growthFactor, int weight, String defaultColor, List<Tuple<Holder<MobEffect>, Integer>> effects, List<IAffix> presetAffixes) {
        this.tier = tier;
        this.numAffixes = numAffixes;
        this.growthFactor = growthFactor;
        this.weight = weight;
        this.defaultColor = defaultColor;
        this.effects = effects;
        this.presetAffixes = presetAffixes;
    }

    public static int getColor(String color) {
        Optional<TextColor> parsedColor = Optional.ofNullable(TextColor.m_131268_((String)color));
        return parsedColor.orElse(TextColor.m_131266_((int)0)).m_131265_();
    }

    public int getTier() {
        return this.tier;
    }

    public TextColor getDefaultColor() {
        return TextColor.m_131268_((String)this.defaultColor);
    }

    public int getNumAffixes() {
        return this.numAffixes;
    }

    public int getGrowthFactor() {
        return this.growthFactor;
    }

    public int getWeight() {
        return this.weight;
    }

    public List<Tuple<Holder<MobEffect>, Integer>> getEffects() {
        return this.effects;
    }

    public List<IAffix> getPresetAffixes() {
        return this.presetAffixes;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "Rank[]";
    }
}

