/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ModEntityTypes;

public class ChampionHelper {
    private static final Set<BlockPos> BEACON_POS = new HashSet<BlockPos>();
    private static MinecraftServer server = null;

    public static boolean isValidChampionEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            if (ChampionsConfig.allowChampionsList) {
                if (ChampionsConfig.allowChampionsPermission == ConfigEnums.Permission.WHITELIST) {
                    return entity.m_6095_().m_204039_(ModEntityTypes.Tags.ALLOW_CHAMPIONS);
                }
                if (ChampionsConfig.allowChampionsPermission == ConfigEnums.Permission.BLACKLIST) {
                    return !entity.m_6095_().m_204039_(ModEntityTypes.Tags.ALLOW_CHAMPIONS);
                }
            } else {
                return entity instanceof Enemy;
            }
        }
        return false;
    }

    public static boolean isValidChampionEntityType(EntityType<?> entityType) {
        if (ChampionsConfig.allowChampionsList) {
            if (ChampionsConfig.allowChampionsPermission == ConfigEnums.Permission.WHITELIST) {
                return entityType.m_204039_(ModEntityTypes.Tags.ALLOW_CHAMPIONS);
            }
            if (ChampionsConfig.allowChampionsPermission == ConfigEnums.Permission.BLACKLIST) {
                return !entityType.m_204039_(ModEntityTypes.Tags.ALLOW_CHAMPIONS);
            }
        }
        return entityType.m_20674_() == MobCategory.MONSTER;
    }

    public static boolean isValidChampion(IChampion.Client client) {
        Optional<Tuple<Integer, String>> rank = client.getRank();
        return rank.isPresent() && rank.map(Tuple::m_14418_).orElse(0) > 0 && !client.getAffixes().isEmpty();
    }

    public static boolean isValidChampion(IChampion.Server server) {
        Optional<Rank> rank = server.getRank();
        return rank.isPresent() && rank.map(Rank::getTier).orElse(-1) > 0 && !server.getAffixes().isEmpty();
    }

    public static boolean isChampionEntity(Entity entity) {
        return ChampionCapability.getCapability(entity).map(champion -> ChampionHelper.isValidChampion(champion.getServer())).orElse(false);
    }

    public static boolean notPotential(LivingEntity livingEntity) {
        return !ChampionHelper.isValidEntity(livingEntity) || !ChampionHelper.isValidDimension(livingEntity.m_9236_().m_46472_().m_135782_()) || ChampionHelper.nearActiveBeacon(livingEntity);
    }

    public static void addBeacon(BlockPos pos) {
        if (server != null) {
            BEACON_POS.add(pos);
        }
    }

    private static boolean isValidEntity(LivingEntity livingEntity) {
        ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getDelegateOrThrow((Object)livingEntity.m_6095_()).m_205785_().m_135782_();
        String entity = rl.toString();
        if (ChampionsConfig.entitiesPermission == ConfigEnums.Permission.BLACKLIST) {
            return !ChampionsConfig.entitiesList.contains(entity);
        }
        return ChampionsConfig.entitiesList.contains(entity);
    }

    public static boolean areEntitiesNearby(BlockPos pos, List<LivingEntity> livingEntities, EntityType<?> entityType) {
        for (LivingEntity livingentity : livingEntities) {
            if (!livingentity.m_6084_() || livingentity.m_213877_() || !pos.m_203195_((Position)livingentity.m_20182_(), 32.0) || livingentity.m_6095_() != entityType) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidDimension(ResourceLocation resourceLocation) {
        String dimension = resourceLocation.toString();
        if (ChampionsConfig.dimensionPermission == ConfigEnums.Permission.BLACKLIST) {
            return !ChampionsConfig.dimensionList.contains(dimension);
        }
        return ChampionsConfig.dimensionList.contains(dimension);
    }

    private static boolean nearActiveBeacon(LivingEntity livingEntity) {
        int range = ChampionsConfig.beaconProtectionRange;
        if (range <= 0) {
            return false;
        }
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        for (BlockPos pos : BEACON_POS) {
            Level level = livingEntity.m_9236_();
            if (!level.m_46749_(pos)) continue;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BeaconBlockEntity) {
                BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
                if (!blockEntity.m_58901_()) {
                    if (!(livingEntity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= (double)(range * range)) || beaconBlockEntity.f_58650_ <= 0) continue;
                    return true;
                }
            }
            toRemove.add(pos);
        }
        BEACON_POS.removeAll(toRemove);
        return false;
    }

    public static void clearBeacons() {
        BEACON_POS.clear();
    }

    public static void setServer(MinecraftServer serverIn) {
        server = serverIn;
    }
}

