/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import top.theillusivec4.champions.Champions;

public class Utils {
    private static Boolean scalingHealthLoaded = null;
    private static Boolean gameStagesLoaded = null;
    private static Boolean kubeJsLoaded = null;
    private static Boolean gateways = null;

    public static boolean isGameStagesLoaded() {
        if (gameStagesLoaded == null) {
            gameStagesLoaded = ModList.get().isLoaded("gamestages");
        }
        return gameStagesLoaded;
    }

    public static boolean isGatewaysLoaded() {
        if (gateways == null) {
            gateways = ModList.get().isLoaded("gateways");
        }
        return gateways;
    }

    public static boolean isScalingHealthLoaded() {
        if (scalingHealthLoaded == null) {
            scalingHealthLoaded = ModList.get().isLoaded("scalinghealth");
        }
        return scalingHealthLoaded;
    }

    public static void createServerConfig(ForgeConfigSpec spec, String suffix) {
        String fileName = "champions-" + suffix + ".toml";
        Champions.getInstance().modContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)spec, fileName);
        File defaults = FMLPaths.GAMEDIR.get().resolve("defaultconfigs").resolve(fileName).toFile();
        if (!defaults.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(Champions.class.getClassLoader().getResourceAsStream(fileName)), (File)defaults);
            }
            catch (IOException e) {
                Champions.LOGGER.error("Error creating default config for {}", (Object)fileName);
            }
        }
    }

    public static ResourceLocation getLocation(String path) {
        return new ResourceLocation("champions", path);
    }

    public static Set<ResourceLocation> getLocationSet(String ... path) {
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        for (String s : path) {
            locations.add(Utils.getLocation(s));
        }
        return locations;
    }
}

