/*
 * Decompiled with CFR 0.152.
 */
package com.wanmine.ghosts.entities.goals;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class GhostPlaceGoal
extends MoveToBlockGoal {
    protected final PathfinderMob f_25598_;
    protected final Ingredient requiredHeld;
    protected final Predicate<BlockState> targetBlockPredicate;
    protected boolean placedBlock;

    public GhostPlaceGoal(PathfinderMob mob, Ingredient requiredHeld, TagKey<Block> targetBlockTag, int horizontalSearchRange, int verticalSearchRange) {
        this(mob, requiredHeld, (BlockState state) -> state.m_204336_(targetBlockTag), horizontalSearchRange, verticalSearchRange);
    }

    public GhostPlaceGoal(PathfinderMob mob, Ingredient requiredHeld, Predicate<BlockState> targetBlockPredicate, int horizontalSearchRange, int verticalSearchRange) {
        super(mob, 1.0, horizontalSearchRange, verticalSearchRange);
        this.f_25598_ = mob;
        this.requiredHeld = requiredHeld;
        this.targetBlockPredicate = targetBlockPredicate;
    }

    public boolean m_8036_() {
        return this.isHoldingValidItem() && super.m_8036_();
    }

    public boolean m_8045_() {
        return this.isHoldingValidItem() && super.m_8045_();
    }

    private boolean isHoldingValidItem() {
        return this.requiredHeld.test(this.f_25598_.m_6844_(EquipmentSlot.MAINHAND));
    }

    public void m_8056_() {
        super.m_8056_();
        this.placedBlock = false;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_() && !this.placedBlock) {
            this.placedBlock = true;
            ItemStack heldStack = this.f_25598_.m_6844_(EquipmentSlot.MAINHAND);
            Item item = heldStack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItem.m_40576_((BlockPlaceContext)new DirectionalPlaceContext(this.f_25598_.m_9236_(), this.f_25598_.m_20183_(), Direction.DOWN, heldStack, Direction.UP));
            }
        }
    }

    protected boolean m_6465_(LevelReader level, BlockPos pos) {
        return level.m_46859_(pos.m_7494_()) && this.targetBlockPredicate.test(level.m_8055_(pos));
    }
}

