/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.tooltips.client.style;

import com.google.common.collect.ImmutableList;
import com.obscuria.tooltips.client.StyleManager;
import com.obscuria.tooltips.client.renderer.TooltipContext;
import com.obscuria.tooltips.client.style.Effects;
import com.obscuria.tooltips.client.style.effect.TooltipEffect;
import com.obscuria.tooltips.client.style.frame.TooltipFrame;
import com.obscuria.tooltips.client.style.icon.TooltipIcon;
import com.obscuria.tooltips.client.style.panel.TooltipPanel;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TooltipStyle {
    private final ImmutableList<TooltipEffect> EFFECTS;
    private final TooltipPanel PANEL;
    private final TooltipFrame FRAME;
    private final TooltipIcon ICON;

    private TooltipStyle(List<TooltipEffect> effects, TooltipPanel panel, TooltipFrame frame, TooltipIcon icon) {
        this.EFFECTS = ImmutableList.copyOf(effects);
        this.PANEL = panel;
        this.FRAME = frame;
        this.ICON = icon;
    }

    public void renderBack(TooltipContext renderer, Vec2 pos, Point size, boolean slot) {
        renderer.pose().m_85836_();
        renderer.pose().m_252880_(0.0f, 0.0f, -50.0f);
        this.PANEL.render(renderer, pos, size, slot);
        renderer.pose().m_85849_();
    }

    public void renderFront(TooltipContext renderer, Vec2 pos, Point size) {
        this.renderEffects(Effects.Order.LAYER_3_TEXT$FRAME, renderer, pos, size);
        renderer.push(() -> {
            renderer.translate(0.0f, 0.0f, -50.0f);
            this.FRAME.render(renderer, pos, size);
        });
        this.renderEffects(Effects.Order.LAYER_4_FRAME$ICON, renderer, pos, size);
        renderer.push(() -> {
            renderer.translate(pos.f_82470_ + 12.0f, pos.f_82471_ + 12.0f, 500.0f);
            renderer.push(() -> this.ICON.render(renderer, -8, -8));
        });
    }

    public void renderEffects(Effects.Order order, TooltipContext renderer, Vec2 pos, Point size) {
        renderer.push(() -> {
            renderer.translate(0.0f, 0.0f, switch (order) {
                default -> throw new IncompatibleClassChangeError();
                case Effects.Order.LAYER_1_BACK -> 0.0f;
                case Effects.Order.LAYER_2_BACK$TEXT -> 100.0f;
                case Effects.Order.LAYER_3_TEXT$FRAME -> 400.0f;
                case Effects.Order.LAYER_4_FRAME$ICON -> 500.0f;
                case Effects.Order.LAYER_5_FRONT -> 1000.0f;
            });
            for (TooltipEffect effect : this.EFFECTS) {
                if (!effect.order().equals((Object)order)) continue;
                effect.render(renderer, pos, size);
            }
        });
    }

    public void reset() {
        this.PANEL.reset();
        this.ICON.reset();
        this.FRAME.reset();
        this.EFFECTS.forEach(TooltipEffect::reset);
    }

    public static class Builder {
        private final List<TooltipEffect> effects = new ArrayList<TooltipEffect>();
        private TooltipPanel panel = StyleManager.DEFAULT_PANEL;
        private TooltipFrame frame = StyleManager.DEFAULT_FRAME;
        private TooltipIcon icon = StyleManager.DEFAULT_ICON;

        public Builder withPanel(TooltipPanel panel) {
            this.panel = panel;
            return this;
        }

        public Builder withFrame(TooltipFrame frame) {
            this.frame = frame;
            return this;
        }

        public Builder withIcon(TooltipIcon icon) {
            this.icon = icon;
            return this;
        }

        public Builder withEffects(List<TooltipEffect> effects) {
            this.effects.addAll(effects);
            return this;
        }

        public TooltipStyle build() {
            return new TooltipStyle(this.effects, this.panel, this.frame, this.icon);
        }
    }
}

