/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.tooltips.client.style.effect;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.obscuria.tooltips.client.renderer.TooltipContext;
import com.obscuria.tooltips.client.style.effect.TooltipEffect;
import com.obscuria.tooltips.client.style.particle.LineParticle;
import com.obscuria.tooltips.client.style.particle.TooltipParticle;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.RandomUtils;
import org.joml.Matrix4f;

public class RimLightingEffect
implements TooltipEffect {
    protected final int START;
    protected final int END;
    protected final int PARTICLE_CENTER;
    protected final int PARTICLE_EDGE;
    protected final List<TooltipParticle> particles = new ArrayList<TooltipParticle>();
    protected float lastParticle = 0.0f;

    public RimLightingEffect(int start, int end, int particleCenter, int particleEdge) {
        this.START = start;
        this.END = end;
        this.PARTICLE_CENTER = particleCenter;
        this.PARTICLE_EDGE = particleEdge;
    }

    @Override
    public void render(TooltipContext context, Vec2 pos, Point size) {
        size = new Point(size.x + 8, size.y + 8);
        Vec2 start = pos.m_165908_(-4.0f);
        float width = 10.0f + 5.0f * (float)Math.cos(context.time());
        Matrix4f matrix4f = context.pose().m_85850_().m_252922_();
        VertexConsumer buffer = context.bufferSource().m_6299_(RenderType.m_286086_());
        buffer.m_252986_(matrix4f, start.f_82470_, start.f_82471_, 0.0f).m_193479_(this.START).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_, start.f_82471_ + (float)size.y, 0.0f).m_193479_(this.START).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + width, start.f_82471_ + (float)size.y - width, 0.0f).m_193479_(this.END).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + width, start.f_82471_ + width, 0.0f).m_193479_(this.END).m_5752_();
        buffer = context.bufferSource().m_6299_(RenderType.m_286086_());
        buffer.m_252986_(matrix4f, start.f_82470_, start.f_82471_, 0.0f).m_193479_(this.START).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + width, start.f_82471_ + width, 0.0f).m_193479_(this.END).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + (float)size.x - width, start.f_82471_ + width, 0.0f).m_193479_(this.END).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + (float)size.x, start.f_82471_, 0.0f).m_193479_(this.START).m_5752_();
        buffer = context.bufferSource().m_6299_(RenderType.m_286086_());
        buffer.m_252986_(matrix4f, start.f_82470_ + (float)size.x - width, start.f_82471_ + width, 0.0f).m_193479_(this.END).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + (float)size.x - width, start.f_82471_ + (float)size.y - width, 0.0f).m_193479_(this.END).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + (float)size.x, start.f_82471_ + (float)size.y, 0.0f).m_193479_(this.START).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + (float)size.x, start.f_82471_, 0.0f).m_193479_(this.START).m_5752_();
        buffer = context.bufferSource().m_6299_(RenderType.m_286086_());
        buffer.m_252986_(matrix4f, start.f_82470_ + width, start.f_82471_ + (float)size.y - width, 0.0f).m_193479_(this.END).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_, start.f_82471_ + (float)size.y, 0.0f).m_193479_(this.START).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + (float)size.x, start.f_82471_ + (float)size.y, 0.0f).m_193479_(this.START).m_5752_();
        buffer.m_252986_(matrix4f, start.f_82470_ + (float)size.x - width, start.f_82471_ + (float)size.y - width, 0.0f).m_193479_(this.END).m_5752_();
        if (context.time() - this.lastParticle >= 0.1f) {
            this.lastParticle = context.time();
            Vec2 center = new Vec2(start.f_82470_ + (float)size.x * 0.5f, start.f_82471_ + (float)size.y * 0.5f);
            int edge = RandomUtils.nextInt((int)1, (int)5);
            float mod = RandomUtils.nextFloat((float)0.0f, (float)1.0f);
            Vec2 from = switch (edge) {
                case 1 -> new Vec2(start.f_82470_, start.f_82471_ + (float)size.y * mod);
                case 2 -> new Vec2(start.f_82470_ + (float)size.x, start.f_82471_ + (float)size.y * mod);
                case 3 -> new Vec2(start.f_82470_ + (float)size.y * mod, start.f_82471_);
                default -> new Vec2(start.f_82470_ + (float)size.y * mod, start.f_82471_ + (float)size.y);
            };
            this.particles.add(new LineParticle(this.PARTICLE_CENTER, this.PARTICLE_EDGE, 1.0f, from, context.lerp(from, center, 0.25f)));
        }
        context.renderParticles(this.particles);
    }

    @Override
    public void reset() {
        this.lastParticle = 0.0f;
        this.particles.clear();
    }

    @Override
    public boolean canStackWith(TooltipEffect other) {
        return !(other instanceof RimLightingEffect);
    }
}

