/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.tooltips.client.style.particle;

import com.mojang.math.Axis;
import com.obscuria.tooltips.client.renderer.TooltipContext;
import com.obscuria.tooltips.client.style.particle.TooltipParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class LineParticle
extends TooltipParticle {
    protected final int START_COLOR;
    protected final int END_COLOR;
    protected Vec2 end;

    public LineParticle(int startColor, int endColor, float lifetime, Vec2 start, Vec2 end) {
        super(lifetime);
        this.START_COLOR = startColor;
        this.END_COLOR = endColor;
        this.position = start;
        this.end = end;
    }

    @Override
    public void renderParticle(TooltipContext context, float lifetime) {
        float mod = 1.0f - (float)Math.pow(1.0f - lifetime / this.MAX_LIFETIME, 3.0);
        float scale = mod < 0.5f ? mod * 2.0f : (mod < 0.8f ? 1.0f : 1.0f - (mod - 0.8f) / 0.2f);
        context.push(() -> {
            context.translate(Mth.m_14179_((float)mod, (float)this.position.f_82470_, (float)this.end.f_82470_), Mth.m_14179_((float)mod, (float)this.position.f_82471_, (float)this.end.f_82471_), 0.0f);
            context.scale(scale, scale, scale);
            context.mul(Axis.f_252403_.m_252961_(context.angle(this.position, this.end) + 1.5707964f));
            context.push(() -> {
                context.translate(-0.5f, 0.5f, 0.0f);
                context.fillGradient(0, -5, 1, 5, this.END_COLOR, this.START_COLOR);
                context.fill(0, 0, 1, 1, this.START_COLOR);
                context.fillGradient(0, 1, 1, 5, this.START_COLOR, this.END_COLOR);
            });
        });
    }
}

