/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.blocks;

import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.ModEvents;
import net.mehvahdjukaar.sleep_tight.core.WakeReason;
import net.mehvahdjukaar.sleep_tight.integration.QuarkCompat;
import net.mehvahdjukaar.sleep_tight.integration.SupplementariesCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HammockBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
IRotatable,
IModBed {
    public static final EnumProperty<HammockPart> PART = EnumProperty.m_61587_((String)"part", HammockPart.class);
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final VoxelShape SHAPE_FULL = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)3.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)8.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)8.0, (double)6.0, (double)16.0);
    private final DyeColor color;

    public HammockBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_56745_).m_60978_(0.2f).m_60955_());
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)HammockPart.MIDDLE))).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, fallDistance * 0.8f);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        HammockPart part = (HammockPart)((Object)state.m_61143_(PART));
        Direction myDir = (Direction)state.m_61143_((Property)f_54117_);
        if (direction.m_122434_() == myDir.m_122434_()) {
            Connection c;
            Direction attDir;
            for (Pair<Direction, HammockPart> v : part.getPiecesDirections(myDir)) {
                if (v.getFirst() != direction) continue;
                Block block = neighborState.m_60734_();
                if (block instanceof HammockBlock) {
                    HammockBlock nh = (HammockBlock)block;
                    if (neighborState.m_61143_(PART) != v.getSecond() || neighborState.m_61143_((Property)f_54117_) != myDir) break;
                    BlockState newState = neighborState.m_60713_((Block)this) ? state : BlocksColorAPI.changeColor((Block)state.m_60734_(), (DyeColor)nh.color).m_152465_(state);
                    return (BlockState)newState.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)neighborState.m_61143_((Property)OCCUPIED)));
                }
                return Blocks.f_50016_.m_49966_();
            }
            if ((attDir = part.getConnectionDirection(myDir)) == direction && ((c = HammockBlock.getConnectionType(attDir, currentPos, level)) == Connection.NONE || c == Connection.FENCE != part.isOnFence())) {
                return Blocks.f_50016_.m_49966_();
            }
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        int i;
        HammockPart part;
        if (!level.f_46443_ && player.m_7500_() && !(part = (HammockPart)((Object)state.m_61143_(PART))).isMaster() && (i = part.getMasterOffset()) != 0 && (blockState = level.m_8055_(blockPos = pos.m_5484_((Direction)state.m_61143_((Property)f_54117_), i))).m_60713_((Block)this) && ((HammockPart)((Object)blockState.m_61143_(PART))).isMaster()) {
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        for (Direction dir : context.m_6232_()) {
            if (!dir.m_122434_().m_122479_()) continue;
            for (int i = 0; i < 2; ++i) {
                Direction opposite;
                BlockPos nextPos;
                Connection type;
                BlockPos p = pos.m_5484_(dir, i);
                if (!level.m_8055_(p).m_60629_(context) || !level.m_6857_().m_61937_(p) || ((type = HammockBlock.getConnectionType(dir, p, (LevelAccessor)level)) != Connection.FENCE || i == 1) && type != Connection.BLOCK || !level.m_8055_(nextPos = p.m_121945_(opposite = dir.m_122424_())).m_60629_(context) || !level.m_6857_().m_61937_(nextPos) || type == Connection.BLOCK && (!level.m_8055_(nextPos = nextPos.m_121945_(opposite)).m_60629_(context) || !level.m_6857_().m_61937_(nextPos)) || HammockBlock.getConnectionType(opposite, nextPos, (LevelAccessor)level) != type) continue;
                HammockPart t = i == 1 ? HammockPart.MIDDLE : type.getHead();
                return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)dir)).m_61124_(PART, (Comparable)((Object)t));
            }
        }
        return null;
    }

    private static Connection getConnectionType(Direction dir, BlockPos pos, LevelAccessor level) {
        Direction opposite;
        BlockPos relative = pos.m_121945_(dir);
        BlockState facingState = level.m_8055_(relative);
        if (facingState.m_60659_((BlockGetter)level, relative, opposite = dir.m_122424_(), SupportType.CENTER)) {
            return Connection.BLOCK;
        }
        if (facingState.m_60734_() instanceof FenceBlock || SleepTight.QUARK && QuarkCompat.isVerticalPost(facingState) || SleepTight.SUPP && SupplementariesCompat.isRopeKnot(facingState)) {
            return Connection.FENCE;
        }
        return Connection.NONE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_) {
            HammockPart part = (HammockPart)((Object)state.m_61143_(PART));
            for (Pair<Direction, HammockPart> v : part.getPiecesDirections((Direction)state.m_61143_((Property)f_54117_))) {
                BlockPos blockPos = pos.m_121945_((Direction)v.getFirst());
                level.m_7731_(blockPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)((HammockPart)((Object)v.getSecond())))), 3);
                if (part != HammockPart.HALF_HEAD) continue;
                blockPos = blockPos.m_121945_((Direction)v.getFirst());
                level.m_7731_(blockPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)HammockPart.HALF_FOOT)), 3);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        HammockPart part = (HammockPart)((Object)state.m_61143_(PART));
        if (part.isOnFence() || part == HammockPart.MIDDLE) {
            return SHAPE_FULL;
        }
        return switch (part.getConnectionDirection((Direction)state.m_61143_((Property)f_54117_))) {
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            default -> SHAPE_NORTH;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED});
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        BlockPos blockPos = HammockBlock.getMasterPos(state, pos);
        return Mth.m_14130_((int)blockPos.m_123341_(), (int)pos.m_123342_(), (int)blockPos.m_123343_());
    }

    private static BlockPos getMasterPos(BlockState state, BlockPos pos) {
        return pos.m_5484_((Direction)state.m_61143_((Property)f_54117_), ((HammockPart)((Object)state.m_61143_(PART))).getMasterOffset());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((HammockPart)((Object)state.m_61143_(PART))).isMaster() ? new HammockTile(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? Utils.getTicker(type, SleepTight.HAMMOCK_TILE.get(), HammockTile::tick) : null;
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        return super.m_8133_(state, level, pos, id, param);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!(state = level.m_8055_(pos = HammockBlock.getMasterPos(state, pos))).m_60713_((Block)this) || player.m_20202_() != null) {
            return InteractionResult.FAIL;
        }
        if (IModBed.tryExploding(level, pos)) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            return InteractionResult.SUCCESS;
        }
        if (!player.m_36341_()) {
            BedEntity.layDown(state, level, pos, player);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Override
    public Vec3 getSleepingPosition(BlockState state, BlockPos pos) {
        Vec3 v = Vec3.m_82512_((Vec3i)pos).m_82492_(0.0, 0.125, 0.0);
        float off = 0.09375f;
        if (!((HammockPart)((Object)state.m_61143_(PART))).isOnFence()) {
            off = (float)((double)off + 0.5);
        }
        v = v.m_231075_((Direction)state.m_61143_((Property)f_54117_), (double)off);
        return v;
    }

    @Override
    public boolean canSetSpawn() {
        return false;
    }

    @Override
    public InteractionResult canSleepAtTime(Level level) {
        return ModEvents.isDayTime(level) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Override
    public Component getSleepingProblemMessage() {
        return Component.m_237115_((String)"message.sleep_tight.cant_rest");
    }

    @Override
    public boolean st_canCauseNightmares() {
        return CommonConfigs.NIGHTMARES_HAMMOCK.get();
    }

    @Override
    public long st_getCooldown() {
        return CommonConfigs.HAMMOCK_COOLDOWN.get().intValue();
    }

    @Override
    public boolean st_hasPenalties() {
        return CommonConfigs.PENALTIES_HAMMOCK.get();
    }

    @Override
    public boolean st_hasRequirements() {
        return CommonConfigs.REQUIREMENT_HAMMOCK.get();
    }

    @Override
    public boolean st_canSpawnBedbugs() {
        return false;
    }

    @Override
    public long st_modifyWakeUpTime(WakeReason reason, long newTime, long dayTime) {
        if (reason == WakeReason.SLEPT_SUCCESSFULLY) {
            long i = dayTime + 24000L;
            return i - i % 24000L - 11001L;
        }
        return IModBed.super.st_modifyWakeUpTime(reason, newTime, dayTime);
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return Optional.empty();
    }

    public Optional<Direction> rotateOverAxis(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return super.rotateOverAxis(state, world, pos, rotation, axis, hit);
    }

    @PlatformOnly(value={"forge"})
    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    @PlatformOnly(value={"forge"})
    public void setBedOccupied(BlockState state, Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    public Direction getBedDirection(BlockState state, LevelReader level, BlockPos pos) {
        return (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
    }

    private static enum Connection {
        BLOCK,
        FENCE,
        NONE;


        public HammockPart getHead() {
            return this == BLOCK ? HammockPart.HALF_HEAD : HammockPart.HEAD;
        }
    }
}

