/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.transformation.BooleanRotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class BoxUtils {
    public static boolean equals(double a, double b, double deviation) {
        return a == b || Math.abs(a - b) < deviation;
    }

    public static boolean greaterEquals(double a, double b, double deviation) {
        return a >= (b > 0.0 ? b - deviation : b + deviation);
    }

    public static boolean insideRect(double one, double two, double minOne, double minTwo, double maxOne, double maxTwo) {
        return one > minOne && one < maxOne && two > minTwo && two < maxTwo;
    }

    private static double lengthIgnoreAxis(Vec3d vec, Axis axis, Vec3d center) {
        vec.sub(center);
        double result = switch (axis) {
            case Axis.X -> Math.sqrt(vec.y * vec.y + vec.z * vec.z);
            case Axis.Y -> Math.sqrt(vec.x * vec.x + vec.z * vec.z);
            case Axis.Z -> Math.sqrt(vec.x * vec.x + vec.y * vec.y);
            default -> 0.0;
        };
        vec.add(center);
        return result;
    }

    public static void includeMaxRotationInBox(ABB box, Vec3d vec, Axis axis, CollisionCoordinator coordinator) {
        double rotation = coordinator.getRotationDegree(axis);
        if (rotation == 0.0) {
            return;
        }
        BoxUtils.includeMaxRotationInBox(box, vec, axis, rotation, coordinator.original().center(), coordinator.getRotationMatrix(axis), coordinator.translation);
    }

    public static void includeMaxRotationInBoxInverse(ABB box, Vec3d vec, Axis axis, CollisionCoordinator coordinator) {
        Vec3d translation;
        double rotation = -coordinator.getRotationDegree(axis);
        if (rotation == 0.0) {
            return;
        }
        if (coordinator.translation != null) {
            translation = new Vec3d(coordinator.translation);
            translation.invert();
        } else {
            translation = null;
        }
        BoxUtils.includeMaxRotationInBox(box, vec, axis, rotation, coordinator.original().center(), coordinator.getRotationMatrixInv(axis), translation);
    }

    private static void includeMaxRotationInBox(ABB box, Vec3d vec, Axis axis, double rotation, Vec3d rotationCenter, Matrix3 matrix, Vec3d translation) {
        Facing facing;
        int quarterRotation;
        Double length = null;
        BooleanRotation state = BooleanRotation.get(axis, vec);
        boolean positive = rotation > 0.0;
        if (rotation >= 90.0) {
            for (quarterRotation = 90; (double)quarterRotation <= Math.abs(rotation) && quarterRotation < 360; quarterRotation += 90) {
                Facing facing2 = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
                if (length == null) {
                    length = BoxUtils.lengthIgnoreAxis(vec, axis, rotationCenter);
                }
                box.include(facing, length);
                if (translation != null) {
                    box.include(facing, length + translation.get(facing.axis));
                }
                state = state.clockwise();
            }
        }
        vec.sub(rotationCenter);
        matrix.transform(vec);
        vec.add(rotationCenter);
        box.include(vec);
        if (quarterRotation <= 360 && state != null && !state.is(vec)) {
            Facing facing3 = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
            if (length == null) {
                length = BoxUtils.lengthIgnoreAxis(vec, axis, rotationCenter);
            }
            box.include(facing, length);
            if (translation != null) {
                box.include(facing, length + translation.get(facing.axis));
            }
        }
    }

    public static double get(AABB bb, Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> bb.f_82291_;
            case Facing.WEST -> bb.f_82288_;
            case Facing.UP -> bb.f_82292_;
            case Facing.DOWN -> bb.f_82289_;
            case Facing.SOUTH -> bb.f_82293_;
            case Facing.NORTH -> bb.f_82290_;
        };
    }

    public static double min(AABB bb, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> bb.f_82288_;
            case Direction.Axis.Y -> bb.f_82289_;
            case Direction.Axis.Z -> bb.f_82290_;
        };
    }

    public static double max(AABB bb, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> bb.f_82291_;
            case Direction.Axis.Y -> bb.f_82292_;
            case Direction.Axis.Z -> bb.f_82293_;
        };
    }

    public static double min(AABB bb, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> bb.f_82288_;
            case Axis.Y -> bb.f_82289_;
            case Axis.Z -> bb.f_82290_;
        };
    }

    public static double max(AABB bb, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> bb.f_82291_;
            case Axis.Y -> bb.f_82292_;
            case Axis.Z -> bb.f_82293_;
        };
    }

    public static Vec3d corner(AABB bb, BoxCorner corner) {
        return new Vec3d(BoxUtils.cornerX(bb, corner), BoxUtils.cornerY(bb, corner), BoxUtils.cornerZ(bb, corner));
    }

    public static double cornerValue(AABB bb, BoxCorner corner, Axis axis) {
        return BoxUtils.get(bb, corner.getFacing(axis));
    }

    public static double cornerX(AABB bb, BoxCorner corner) {
        return BoxUtils.get(bb, corner.x);
    }

    public static double cornerY(AABB bb, BoxCorner corner) {
        return BoxUtils.get(bb, corner.y);
    }

    public static double cornerZ(AABB bb, BoxCorner corner) {
        return BoxUtils.get(bb, corner.z);
    }

    public static Vec3d[] getCorners(AABB bb) {
        Vec3d[] corners = new Vec3d[BoxCorner.values().length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = BoxUtils.corner(bb, BoxCorner.values()[i]);
        }
        return corners;
    }

    public static Vec3d[] getRotatedCorners(AABB bb, IVecOrigin origin) {
        Vec3d[] corners = BoxUtils.getCorners(bb);
        for (int i = 0; i < corners.length; ++i) {
            origin.transformPointToWorld(corners[i]);
        }
        return corners;
    }

    public static boolean intersectsWithAxis(AABB bb, AABB other, Axis one, Axis two) {
        return bb.m_82340_(one.toVanilla()) < other.m_82374_(one.toVanilla()) && bb.m_82374_(one.toVanilla()) > bb.m_82340_(one.toVanilla()) && bb.m_82340_(two.toVanilla()) < bb.m_82374_(two.toVanilla()) && bb.m_82374_(two.toVanilla()) > bb.m_82340_(two.toVanilla());
    }

    public static boolean intersectsWithAxis(AABB bb, Axis one, Axis two, double valueOne, double valueTwo) {
        return bb.m_82340_(one.toVanilla()) < valueOne && bb.m_82374_(one.toVanilla()) > valueOne && bb.m_82340_(two.toVanilla()) < valueTwo && bb.m_82374_(two.toVanilla()) > valueTwo;
    }

    public static double calculateAxisOffset(Axis axis, Axis one, Axis two, AABB bb, AABB other, double offset) {
        if (BoxUtils.intersectsWithAxis(bb, other, one, two)) {
            double newDistance;
            if (offset > 0.0 && other.m_82374_(axis.toVanilla()) <= bb.m_82340_(axis.toVanilla())) {
                double newDistance2 = bb.m_82340_(axis.toVanilla()) - other.f_82291_;
                if (newDistance2 < offset) {
                    return newDistance2;
                }
            } else if (offset < 0.0 && other.m_82340_(axis.toVanilla()) >= bb.m_82374_(axis.toVanilla()) && (newDistance = bb.m_82374_(axis.toVanilla()) - other.m_82340_(axis.toVanilla())) > offset) {
                return newDistance;
            }
        }
        return offset;
    }

    public static double getIntersectionVolume(AABB bb, ABB other) {
        double d0 = Math.max(bb.f_82288_, other.minX);
        double d1 = Math.max(bb.f_82289_, other.minY);
        double d2 = Math.max(bb.f_82290_, other.minZ);
        double d3 = Math.min(bb.f_82291_, other.maxX);
        double d4 = Math.min(bb.f_82292_, other.maxY);
        double d5 = Math.min(bb.f_82293_, other.maxZ);
        if (d0 < d3 && d1 < d4 && d2 < d5) {
            return Math.abs((d3 - d0) * (d4 - d1) * (d5 - d2));
        }
        return 0.0;
    }
}

