/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class RibbitApplyBuffGoal
extends Goal {
    private static final int TICKS_UNTIL_BUFF_APPLIED = 22;
    private final RibbitEntity ribbit;
    private final double range;
    private final int cooldownTicks;
    private final Map<MobEffect, Integer> effects;
    private int ticksSinceStart;

    public RibbitApplyBuffGoal(RibbitEntity ribbit, double range, int cooldownTicks) {
        this.ribbit = ribbit;
        this.range = range;
        this.cooldownTicks = cooldownTicks;
        this.effects = new HashMap<MobEffect, Integer>();
        this.effects.put(MobEffects.f_19605_, 1200);
        this.effects.put(MobEffects.f_19606_, 2400);
        this.effects.put(MobEffects.f_19600_, 2400);
        this.effects.put(MobEffects.f_19603_, 2400);
        this.effects.put(MobEffects.f_19598_, 2400);
        this.effects.put(MobEffects.f_19616_, 2400);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.ribbit.getBuffCooldown() == 0 && !this.ribbit.m_9236_().m_45955_(TargetingConditions.m_148352_().m_26883_(this.range), (LivingEntity)this.ribbit, this.ribbit.m_20191_().m_82377_(this.range, 5.0, this.range)).isEmpty();
    }

    public boolean m_8045_() {
        return this.ticksSinceStart >= 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.ticksSinceStart >= 22) {
            this.applyBuffs();
        } else if (this.ticksSinceStart >= 0) {
            ++this.ticksSinceStart;
        }
    }

    public void m_8056_() {
        this.ticksSinceStart = 0;
        this.ribbit.setBuffing(true);
        this.ribbit.m_216990_((SoundEvent)SoundModule.ENTITY_RIBBIT_MAGIC.get());
    }

    public void m_8041_() {
        this.ribbit.setBuffCooldown(this.cooldownTicks);
        this.ticksSinceStart = 0;
    }

    public boolean m_6767_() {
        return false;
    }

    private void applyBuffs() {
        this.ticksSinceStart = -1;
        List nearbyPlayers = this.ribbit.m_9236_().m_45955_(TargetingConditions.m_148352_().m_26883_(this.range), (LivingEntity)this.ribbit, this.ribbit.m_20191_().m_82377_(this.range, 5.0, this.range));
        MobEffect randomEffect = (MobEffect)this.effects.keySet().stream().toList().get(this.ribbit.m_217043_().m_188503_(this.effects.size()));
        int effectDuration = this.effects.get(randomEffect);
        for (Player player : nearbyPlayers) {
            player.m_7292_(new MobEffectInstance(randomEffect, effectDuration, 0));
        }
        this.ribbit.setBuffing(false);
    }
}

