/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class RibbitWaterCropsGoal
extends Goal {
    private static final int TICKS_TO_WATER = 34;
    private final RibbitEntity ribbit;
    private final double range;
    private final int cooldownTicks;
    private final float speedModifier;
    private BlockPos targetCropPos;
    private int wateringTicks = 0;

    public RibbitWaterCropsGoal(RibbitEntity ribbit, double range, float speedModifier, int cooldownTicks) {
        this.ribbit = ribbit;
        this.range = range;
        this.speedModifier = speedModifier;
        this.cooldownTicks = cooldownTicks;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void m_8056_() {
        float waterModifier = this.ribbit.m_20069_() ? 2.0f : 1.0f;
        this.ribbit.m_21573_().m_26519_((double)((float)this.targetCropPos.m_123341_() + 0.5f), (double)this.targetCropPos.m_123342_(), (double)((float)this.targetCropPos.m_123343_() + 0.5f), (double)(this.speedModifier * waterModifier));
    }

    public void m_8041_() {
        this.wateringTicks = 0;
        this.ribbit.setWatering(false);
        this.targetCropPos = null;
        this.ribbit.setBuffCooldown(this.cooldownTicks);
    }

    public boolean m_8036_() {
        if (this.ribbit.m_9236_().m_46462_()) {
            return false;
        }
        Optional cropPos = BlockPos.m_121930_((BlockPos)this.ribbit.m_20097_(), (int)((int)this.range), (int)5, blockPos -> RibbitWaterCropsGoal.isValidCropBlock((LevelReader)this.ribbit.m_9236_(), blockPos, this.ribbit.m_9236_().m_8055_(blockPos)) && this.ribbit.getBuffCooldown() == 0);
        cropPos.ifPresent(blockPos -> {
            this.targetCropPos = blockPos;
        });
        return this.ribbit.getBuffCooldown() == 0 && cropPos.isPresent();
    }

    public boolean m_8045_() {
        if (this.wateringTicks < 0) {
            return false;
        }
        boolean cropNearby = false;
        for (BlockPos nearbyPos : this.getNearbyPositions()) {
            if (!RibbitWaterCropsGoal.isValidCropBlock((LevelReader)this.ribbit.m_9236_(), nearbyPos, this.ribbit.m_9236_().m_8055_(nearbyPos))) continue;
            cropNearby = true;
            break;
        }
        return this.ribbit.m_20275_((float)this.targetCropPos.m_123341_() + 0.5f, this.targetCropPos.m_123342_(), (float)this.targetCropPos.m_123343_() + 0.5f) > 1.0 || cropNearby || this.wateringTicks > 0;
    }

    public boolean m_6767_() {
        return this.wateringTicks < 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.wateringTicks < 0) {
            return;
        }
        float waterModifier = this.ribbit.m_20069_() ? 2.0f : 1.0f;
        this.ribbit.m_21573_().m_26517_((double)(this.speedModifier * waterModifier));
        if (this.ribbit.m_20275_((float)this.targetCropPos.m_123341_() + 0.5f, this.targetCropPos.m_123342_(), (float)this.targetCropPos.m_123343_() + 0.5f) < 2.0) {
            if (this.wateringTicks == 0) {
                this.ribbit.m_21563_().m_24946_((double)((float)this.targetCropPos.m_123341_() + 0.5f), this.ribbit.m_20188_(), (double)((float)this.targetCropPos.m_123343_() + 0.5f));
            }
            this.ribbit.m_21573_().m_26573_();
            this.ribbit.setWatering(true);
            ++this.wateringTicks;
            if (this.wateringTicks >= 34) {
                for (BlockPos pos : this.getNearbyPositions()) {
                    RibbitWaterCropsGoal.tryGrowCropAtPos(this.ribbit.m_9236_(), pos);
                }
                this.wateringTicks = -1;
            }
        } else if (this.ribbit.m_20275_((float)this.targetCropPos.m_123341_() + 0.5f, this.targetCropPos.m_123342_(), (float)this.targetCropPos.m_123343_() + 0.5f) < 3.0) {
            this.ribbit.setWatering(false);
            this.ribbit.m_21566_().m_6849_((double)((float)this.targetCropPos.m_123341_() + 0.5f), (double)this.targetCropPos.m_123342_(), (double)((float)this.targetCropPos.m_123343_() + 0.5f), (double)(this.speedModifier * waterModifier));
        } else {
            this.ribbit.setWatering(false);
            this.ribbit.m_21573_().m_26519_((double)((float)this.targetCropPos.m_123341_() + 0.5f), (double)this.targetCropPos.m_123342_(), (double)((float)this.targetCropPos.m_123343_() + 0.5f), (double)(this.speedModifier * waterModifier));
        }
    }

    private static void tryGrowCropAtPos(Level level, BlockPos pos) {
        BonemealableBlock bonemealableBlock;
        Block block;
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_204336_(BlockTags.f_13073_) && (block = blockState.m_60734_()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)level, pos, blockState, level.f_46443_) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (bonemealableBlock.m_214167_(level, level.f_46441_, pos, blockState)) {
                bonemealableBlock.m_214148_(serverLevel, level.f_46441_, pos, blockState);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123804_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, 8, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static boolean isValidCropBlock(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        BonemealableBlock bonemealableBlock;
        Block block;
        return blockState.m_204336_(BlockTags.f_13073_) && (block = blockState.m_60734_()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_(levelReader, blockPos, blockState, levelReader.m_5776_());
    }

    private Iterable<BlockPos> getNearbyPositions() {
        return BlockPos.m_121976_((int)Mth.m_14107_((double)(this.ribbit.m_20185_() - 1.0)), (int)Mth.m_14107_((double)(this.ribbit.m_20186_() - 1.0)), (int)Mth.m_14107_((double)(this.ribbit.m_20189_() - 1.0)), (int)Mth.m_14107_((double)(this.ribbit.m_20185_() + 1.0)), (int)Mth.m_14107_((double)((double)this.ribbit.m_146904_() + 1.0)), (int)Mth.m_14107_((double)(this.ribbit.m_20189_() + 1.0)));
    }
}

