/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.Window;
import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.ExperiencePickup;
import dev.obscuria.lootjournal.client.pickup.GroupedItemsPickup;
import dev.obscuria.lootjournal.client.pickup.IPickup;
import dev.obscuria.lootjournal.client.pickup.ItemPickup;
import dev.obscuria.lootjournal.client.render.Anchor;
import dev.obscuria.lootjournal.client.render.Style;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public final class PickupComponent {
    private static final HashMap<Integer, PickupInstance> occupied = Maps.newHashMap();
    private static final List<PickupInstance> visible = Lists.newArrayList();
    private static final Deque<IPickup> queued = Queues.newArrayDeque();

    public static void render(GuiGraphics graphics) {
        Window window = Minecraft.m_91087_().m_91268_();
        int maxVisible = LootJournal.CONFIG.maxVisibleNotifications;
        Style style = LootJournal.CONFIG.style;
        Anchor anchor = LootJournal.CONFIG.anchor;
        int originX = anchor.originX(window);
        int originY = anchor.originY(window);
        int step = anchor.step();
        visible.removeIf(instance -> {
            if (!instance.render(graphics, style, anchor, originX, originY + step * instance.index)) {
                return false;
            }
            occupied.remove(instance.index);
            return true;
        });
        if (queued.isEmpty() || visible.size() >= maxVisible) {
            return;
        }
        queued.removeIf(pickup -> {
            int index = PickupComponent.findFreeIndex(maxVisible);
            if (index <= -1) {
                return false;
            }
            PickupInstance instance = new PickupInstance((IPickup)pickup, index);
            visible.add(instance);
            occupied.put(index, instance);
            return true;
        });
    }

    public static void appendItem(int itemId, int playerId, int amount) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_19879_() != playerId) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(itemId);
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity entity2 = (ItemEntity)entity;
        ItemStack stack = entity2.m_32055_().m_41777_();
        stack.m_41764_(amount);
        PickupComponent.appendItem(stack);
    }

    public static void appendItem(ItemStack stack) {
        if (!LootJournal.isAllowed(stack)) {
            return;
        }
        int maxVisible = LootJournal.CONFIG.maxVisibleNotifications;
        int maxQueued = LootJournal.CONFIG.maxQueuedNotifications;
        PickupComponent.append(visible.size() > maxVisible && queued.size() > maxQueued ? new GroupedItemsPickup(stack) : new ItemPickup(stack));
    }

    public static void appendExperience(int amount) {
        if (!LootJournal.CONFIG.displayExperience) {
            return;
        }
        PickupComponent.append(new ExperiencePickup(amount));
    }

    private static void append(IPickup pickup) {
        if (PickupComponent.tryMerge(pickup)) {
            return;
        }
        int index = PickupComponent.findFreeIndex(LootJournal.CONFIG.maxVisibleNotifications);
        if (index > -1) {
            PickupInstance instance = new PickupInstance(pickup, index);
            visible.add(instance);
            occupied.put(index, instance);
        } else if (queued.size() < LootJournal.CONFIG.maxQueuedNotifications) {
            queued.add(pickup);
        }
    }

    private static boolean tryMerge(IPickup pickup) {
        for (PickupInstance instance : visible) {
            if (!instance.tryMerge(pickup)) continue;
            return true;
        }
        for (IPickup other : queued) {
            if (!other.tryMerge(pickup)) continue;
            return true;
        }
        return false;
    }

    private static int findFreeIndex(int size) {
        for (int i = 0; i < size; ++i) {
            if (occupied.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    private static final class PickupInstance {
        private static final long FADE_IN = 750L;
        private static final long FADE_OUT = 1500L;
        private final IPickup pickup;
        private long startTime = -1L;
        private long lastTime;
        private double delta;
        private double ratio;
        public int index;

        public PickupInstance(IPickup pickup, int index) {
            this.pickup = pickup;
            this.index = index;
        }

        public boolean render(GuiGraphics graphics, Style style, Anchor anchor, int x, int y) {
            long currentTime = Util.m_137550_();
            if (this.startTime < 0L) {
                this.startTime = currentTime;
                this.lastTime = currentTime;
            }
            this.delta = (double)(currentTime - this.lastTime) / 1000.0;
            this.lastTime = currentTime;
            long time = currentTime - this.startTime;
            if (!Minecraft.m_91087_().f_91066_.f_92062_) {
                style.render(this.pickup, graphics, anchor, x, y, this.ratio, time);
            }
            this.updateRatio(time);
            return time > this.getDisplayTime();
        }

        public boolean tryMerge(IPickup other) {
            if (this.pickup.tryMerge(other)) {
                this.startTime = Util.m_137550_();
                return true;
            }
            return this.pickup.tryMerge(other);
        }

        private void updateRatio(long time) {
            if (time <= 750L) {
                this.ratio = Math.min(this.ratio + this.delta * 2.0, 1.0);
            }
            if (time >= this.getDisplayTime() - 1500L) {
                this.ratio = Math.max(this.ratio - this.delta, 0.0);
            }
        }

        private long getLifetime() {
            return (long)(1000.0 * LootJournal.CONFIG.notificationLifetime);
        }

        private long getDisplayTime() {
            return 2250L + this.getLifetime();
        }
    }
}

