/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;

public class BackpackUpgradeRecipe
extends SmithingTransformRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;

    public BackpackUpgradeRecipe(ResourceLocation id, Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, ItemStack pResult) {
        super(id, pTemplate, pBase, pAddition, pResult);
        this.template = pTemplate;
        this.base = pBase;
        this.addition = pAddition;
        this.result = pResult;
    }

    public ItemStack m_5874_(Container pInput, RegistryAccess pRegistryAccess) {
        int tier;
        ItemStack result = this.result.m_41777_();
        CompoundTag compoundtag = pInput.m_8020_(1).m_41783_();
        if (compoundtag != null) {
            result.m_41751_(compoundtag.m_6426_());
        }
        ItemStack base = pInput.m_8020_(1);
        ItemStack addition = pInput.m_8020_(2);
        if (addition.m_150930_(Tiers.of(tier = NbtHelper.getOrDefault(base, "Tier", 0).intValue()).getTierUpgradeIngredient())) {
            this.upgradeInventory(result, Tiers.of(tier).getNextTier());
            return result;
        }
        return ItemStack.f_41583_;
    }

    public void upgradeInventory(ItemStack stack, Tiers.Tier nextTier) {
        NbtHelper.set(stack, "Tier", nextTier.getOrdinal());
        NbtHelper.set(stack, "StorageSlots", nextTier.getStorageSlots());
        NbtHelper.set(stack, "UpgradeSlots", nextTier.getUpgradeSlots());
        NbtHelper.set(stack, "ToolSlots", nextTier.getToolSlots());
        if (NbtHelper.has(stack, "RenderInfo")) {
            NbtHelper.set(stack, "RenderInfo", this.getUpgradedTanksCapacity(stack, nextTier.getStorageSlots()));
        }
    }

    public RenderInfo getUpgradedTanksCapacity(ItemStack stack, int storageSlots) {
        boolean extended = storageSlots > 81;
        int rows = (int)Math.ceil((double)storageSlots / (double)(extended ? 11 : 9)) + (extended ? 2 : 0);
        RenderInfo infoTag = (RenderInfo)NbtHelper.get(stack, "RenderInfo");
        RenderInfo newInfo = new RenderInfo(infoTag.compoundTag().m_6426_());
        newInfo.updateCapacity(Tiers.of(NbtHelper.getOrDefault(stack, "Tier", 0)).getTankCapacityPerRow() * rows);
        return newInfo;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.BACKPACK_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BackpackUpgradeRecipe> {
        public BackpackUpgradeRecipe fromJson(ResourceLocation p_266953_, JsonObject p_266720_) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_266720_, (String)"template"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_266720_, (String)"base"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_266720_, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_266720_, (String)"result"));
            return new BackpackUpgradeRecipe(p_266953_, ingredient, ingredient1, ingredient2, itemstack);
        }

        public BackpackUpgradeRecipe fromNetwork(ResourceLocation p_267117_, FriendlyByteBuf p_267316_) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)p_267316_);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)p_267316_);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)p_267316_);
            ItemStack itemstack = p_267316_.m_130267_();
            return new BackpackUpgradeRecipe(p_267117_, ingredient, ingredient1, ingredient2, itemstack);
        }

        public void toNetwork(FriendlyByteBuf p_266746_, BackpackUpgradeRecipe p_266927_) {
            p_266927_.template.m_43923_(p_266746_);
            p_266927_.base.m_43923_(p_266746_);
            p_266927_.addition.m_43923_(p_266746_);
            p_266746_.m_130055_(p_266927_.result);
        }
    }
}

